% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extras.R
\name{make_visit_labels}
\alias{make_visit_labels}
\title{Make Visit Labels Based on a Numeric Vector}
\usage{
make_visit_labels(t, visit = "VIS", baseline = "BASELINE", pad = "0")
}
\arguments{
\item{t}{A non-empty numeric vector of unique, \link{finite} elements in ascending
order.}

\item{visit}{A single character string specifying the prefix to add to \code{t}.}

\item{baseline}{A single character string to use for the first timepoint's
label. Alternatively, set to \code{NULL} so that all timepoints will have the
prefix specified by \code{visit}.}

\item{pad}{The character to use to pad between \code{visit} and \code{t} so that
the places of \code{t} are aligned. Alternatively, set to \code{NULL} so that \code{t} is
automatically converted to \code{character} without special formatting. This can
result in numbers in labels not being aligned or not being in
"alphabetical" \link{order}.}
}
\value{
A \link{character} vector of length \code{\link{length}}\code{(t)}.
}
\description{
Create a character vector of values to be used as labels for a \link{factor}.
}
\details{
Places \code{visit} as a prefix before the values of \code{t}. If \code{pad} is not \code{NULL},
the values of \code{t} are first \code{format}ted so that their places are aligned, and
they are left-padded with zeros.

If \code{baseline} is not \code{NULL} it is used as the first label regardless of the
value of \code{t[1]}.

Uses \code{\link{make.unique}}\code{(sep = "_")} in case any elements are identical after
\link{format}ting.
}
\examples{
make_visit_labels(c(0, 5, 13, 101))

make_visit_labels(c(0, 5.23453, 13, 101.4))

make_visit_labels(c(0, 5.23453, 13, 101.4), baseline = NULL, pad = " ")

make_visit_labels(c(0, 5.23453, 13, 101.4), visit = "Week", pad = NULL)
}
