% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spline.R
\name{time_spline}
\alias{time_spline}
\title{Create Natural Cubic Spline Approximations for Continuous Time}
\usage{
time_spline(
  time,
  df = NULL,
  ...,
  basis = time_spline_basis(time, df = df, ...)
)
}
\arguments{
\item{time}{A numeric vector of values.}

\item{df, ...}{Only used if \code{basis} is left as the default. Passed to
\code{\link[=time_spline_basis]{time_spline_basis()}} (which passes all arguments to \code{\link[splines:ns]{splines::ns()}}) to
calculate the spline \code{basis}.}

\item{basis}{Spline basis for which to create approximations of \code{time}.
Defaults to \code{\link{time_spline_basis}}\verb{(time, df = df, ...)}.}
}
\value{
Matrix with the same dimensions as \code{basis}. Contains \code{basis} as an
\link{attr}ibute.
}
\description{
Accepts or constructs a natural cubic spline \code{basis} for continuous \code{time}
and yields a matrix of approximations for \code{time} according to that \code{basis}.
}
\details{
\code{time_spline()} is primarily useful because it can use one step to create the
spline \code{basis} from \code{time} and then re-input \code{time} into the spline \code{basis}
to obtain the spline approximations. Alternatively, it can calculate
predictions from a basis supplied to the \code{basis} argument.
}
\examples{
time_spline(Theoph$Time, df = 3)

# Or, compute the spline basis beforehand, and then pass it to time_spline()
basis <-
  splines::bs(Theoph$Time, df = 3, Boundary.knots = c(0, max(Theoph$Time)))

time_spline(Theoph$Time, basis = basis)
}
