% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match-moments.R
\name{ssd_match_moments}
\alias{ssd_match_moments}
\title{Match Moments}
\usage{
ssd_match_moments(
  dists = ssd_dists_bcanz(),
  meanlog = 1,
  sdlog = 1,
  ...,
  nsim = 1e+05
)
}
\arguments{
\item{dists}{A character vector of the distribution names.}

\item{meanlog}{The mean on the log scale.}

\item{sdlog}{The standard deviation on the log scale.}

\item{...}{Unused.}

\item{nsim}{A positive whole number of the number of simulations to generate.}
}
\value{
a named list of the values that produce the moment values by distribution and term.
}
\description{
Gets a named list of the values that produce
the moment values (meanlog and sdlog) by distribution and term.
}
\examples{
moments <- ssd_match_moments()
print(moments)
ssd_hc(moments)
ssd_plot_cdf(moments)
}
\seealso{
\code{\link[=estimates.fitdists]{estimates.fitdists()}}, \code{\link[=ssd_hc]{ssd_hc()}} and \code{\link[=ssd_plot_cdf]{ssd_plot_cdf()}}
}
