% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indent.R
\name{compute_indent_indices}
\alias{compute_indent_indices}
\title{Compute the indices that need indention}
\usage{
compute_indent_indices(pd, token_opening, token_closing = NULL)
}
\arguments{
\item{pd}{A parse table.}

\item{token_opening}{A character vector with tokens that could induce
indention for subsequent tokens.}

\item{token_closing}{A character vector with tokens that could terminate
indention for previous tokens. If \code{NULL} (the default), indention should
end with the last token in the parse table.}
}
\description{
Based on \code{token}, find the rows in \code{pd} that need to be indented.
}
\details{
Two cases are fundamentally different:
\itemize{
\item Indention based on operators (e.g '+'), where all subsequent tokens should
be indented.
\item Indention based on braces (e.g. '('), where just the tokens between the
opening and the closing brace have to be indented.
}

To cover the second case, we need \code{token_closing} because it cannot be taken
for granted that \code{token_closing} is always the last token in \code{pd}. For
example in if-else expressions, this is not the case and indenting
everything between '(' and the penultimate token would result in the wrong
formatting.
}
\section{Handing of \code{[[}}{

Since text \code{[[} has token \code{"LBB"} and text \verb{]]} is parsed as two independent
\verb{]} (see 'Examples'), indention has to stop at the first \verb{]}.
}

\examples{
styler:::parse_text("a[1]")
styler:::parse_text("a[[1\n]]")
}
\keyword{internal}
