% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{sd_question}
\alias{sd_question}
\title{Create a survey question}
\usage{
sd_question(
  id,
  type = NULL,
  label = NULL,
  option = NULL,
  options = NULL,
  cols = "80",
  direction = "horizontal",
  status = "default",
  width = "100\%",
  height = NULL,
  selected = NULL,
  label_select = "Choose an option...",
  grid = TRUE,
  individual = TRUE,
  justified = FALSE,
  force_edges = TRUE,
  placeholder = NULL,
  resize = NULL,
  row = NULL,
  default = NULL,
  yml = "questions.yml",
  ...
)
}
\arguments{
\item{id}{A unique identifier for the question, which will be used as the
variable name in the resulting survey data.}

\item{type}{Specifies the type of question. Possible values are \code{"select"},
\code{"mc"}, \code{"mc_multiple"}, \code{"mc_buttons"}, \code{"mc_multiple_buttons"}, \code{"text"},
\code{"textarea"}, \code{"numeric"}, \code{"slider"}, \code{"slider_numeric"}, \code{"date"},
\code{"daterange"}, and \code{"matrix"}. Defaults to \code{NULL}.}

\item{label}{Character string. The label for the UI element, which can be
formatted with markdown. Defaults to \code{NULL}}

\item{option}{Named vector for the \code{"select"}, \code{"radio"}, \code{"checkbox"},
and \code{"slider"} question types, or numeric vector for \code{"slider_numeric"}
question type. Can be provided in multiple formats:
\itemize{
\item Named vector: \code{c("Display A" = "value_a", "Display B" = "value_b")} -
Names are shown in UI, values are stored in database
\item Unnamed character vector: \code{c("Option 1", "Option 2")} - Values are shown in UI
and automatically converted to snake_case for database storage
(e.g., "option_1", "option_2")
\item Unnamed numeric vector: \code{c(1, 2, 3)} - For non-slider questions, converted to
\code{c("1" = "1", "2" = "2", "3" = "3")}. For \code{slider_numeric}, kept as numeric.
}}

\item{options}{Alias for \code{option}. Either \code{option} or \code{options} can be used.
If both are provided, \code{option} takes precedence. Supports the same formats
as \code{option}.}

\item{cols}{Integer. Number of columns for the \code{"textarea"} question type.
Defaults to \code{80}.}

\item{direction}{Character string. The direction for button groups
(\code{"horizontal"} or \code{"vertical"}). Defaults to \code{"horizontal"}.}

\item{status}{Character string. The status for button groups.
Defaults to \code{"default"}.}

\item{width}{Character string. The width of the UI element.
Defaults to \code{"100\%"}.}

\item{height}{Character string. The height of the input for the
\code{"textarea"} question type. Defaults to \code{"100px"}.}

\item{selected}{Value. The selected value(s) for certain input elements.}

\item{label_select}{Character string. The label for the select input.
Defaults to \code{"Choose an option..."}.}

\item{grid}{Logical. Whether to show a grid for slider input.
Defaults to \code{TRUE}.}

\item{individual}{Logical. Whether buttons in a group should be individually
styled. Defaults to \code{TRUE}.}

\item{justified}{Logical. Whether buttons in a group should fill the width
of the parent div. Defaults to \code{FALSE}.}

\item{force_edges}{Logical. Whether to force edges for slider input.
Defaults to \code{TRUE}.}

\item{placeholder}{Character string. Placeholder text for \code{"text"} and
\code{"textarea"} question types.}

\item{resize}{Character string. Resize option for textarea input.
Defaults to \code{NULL}.}

\item{row}{List. Used for \code{"matrix"} type questions. Contains the row labels
and their corresponding IDs.}

\item{default}{Numeric, length 1 (for a single sided slider), or 2 for a
two sided (range based) slider. Values to be used as the starting default
for the slider. Defaults to the median of values.}

\item{yml}{Character string. The name of the YAML file to load question configurations from.
Defaults to \code{"questions.yml"}. Custom YAML files can be specified, either in
the root directory or subdirectories (e.g., \code{"folder/custom.yml"}).}

\item{...}{Additional arguments, often specific to different input types.
Examples include \code{pre}, \code{sep}, \code{step}, and \code{animate} for \code{"slider"} and
\code{"slider_numeric"} question types, etc.}
}
\value{
A 'shiny' UI element wrapped in a div with a data attribute for
question ID.
}
\description{
This function creates various types of survey questions for use in a Surveydown survey.
}
\details{
The function supports various question types:
\itemize{
\item \code{"select"}: A dropdown selection
\item \code{"mc"}: Multiple choice (single selection)
\item \code{"mc_multiple"}: Multiple choice (multiple selections allowed)
\item \code{"mc_buttons"}: Multiple choice with button-style options (single selection)
\item \code{"mc_multiple_buttons"}: Multiple choice with button-style options (multiple selections allowed)
\item \code{"text"}: Single-line text question
\item \code{"textarea"}: Multi-line text question
\item \code{"numeric"}: Numeric question
\item \code{"slider"}: Slider question
\item \code{"slider_numeric"}: Extended numeric slider question
\item \code{"date"}: Date question
\item \code{"daterange"}: Date range question
\item \code{"matrix"}: Matrix-style question with rows and columns
}

For \code{"matrix"} type questions, use the \code{row} parameter to define the rows of
the matrix. Each element in the \code{row} list should have a name (used as the
row ID) and a value (used as the row label).
}
\examples{
if (interactive()) {
  library(surveydown)

  # Use sd_question() to create questions in R chunks of survey.qmd:
  # sd_question(
  #   id    = "favorite_penguin_static",
  #   type  = "mc",
  #   label = "Which type of penguin do you like the best?",
  #   option = c(
  #     "Adélie"    = "adelie",
  #     "Chinstrap" = "chinstrap",
  #     "Gentoo"    = "gentoo"
  #   )
  #  )

  # Use sd_question() to create reactive questions in app.R under server:
  # server <- function(input, output, session) {
  #   sd_question(
  #     id    = "favorite_penguin_reactive",
  #     type  = "mc",
  #     label = "Which type of penguin do you like the best?",
  #     option = c(
  #       "Adélie"    = "adelie",
  #       "Chinstrap" = "chinstrap",
  #       "Gentoo"    = "gentoo"
  #     )
  #    )
  #   sd_server()
  # }

  # Find a working directory and start from a template:
  sd_create_survey(template = "default")
  # This creates survey.qmd and app.R - launch the survey using app.R
}

}
