% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table1.R
\name{render.strat}
\alias{render.strat}
\title{Render strata labels for default table1 output.}
\usage{
render.strat(strata, ..., transpose = F)
}
\arguments{
\item{strata}{A named \code{list} of \code{data.frame}s.}

\item{...}{Additional arguments.}

\item{transpose}{Logical indicating whether on not the table is transposed.}
}
\value{
A \code{character}, which may contain HTML markup.
}
\description{
Called from \code{\link{table1}} to render the strata labels for display in
the table. This is the default function, but it can be overriden by a
user-supplied function.
}
\examples{
dat <- expand.grid(id=1:10, sex=c("Male", "Female"), treat=c("Treated", "Placebo"))
strata <- split(dat, dat$treat)
render.strat(strata)
}
\keyword{internal}
