% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unifyMatrixContent.R
\name{unifyMatrixContent}
\alias{unifyMatrixContent}
\title{unifyMatrixContent}
\usage{
unifyMatrixContent(
  x,
  letter.convert = TRUE,
  greek2text = TRUE,
  text2num = TRUE,
  correctComma = FALSE,
  na.rm = TRUE
)
}
\arguments{
\item{x}{A character matrix or list of character matrices.}

\item{letter.convert}{Logical. If TRUE, hexadecimal- and html-encoded letters will be unified and converted to Unicode with JATSdecoder::letter.convert().}

\item{greek2text}{Logical. If TRUE and 'letter.convert=TRUE', converts and unifies various Greek letters to a text-based form (e.g., 'alpha', 'beta').}

\item{text2num}{Logical. If TRUE, textual representations of numbers (words, exponents, fractions) are converted to digit numbers.}

\item{correctComma}{Logical. If TRUE, commas used as decimal are converted to dots, big mark commas are removed.}

\item{na.rm}{Logical. If TRUE, cells with NA, or only minus, hyphen, slash, or dot are set to empty cells.}
}
\value{
A unified character matrix or list of character matrices.
}
\description{
Unifies textual and numerical content of character matrices. Unifies hyphens, spaces, hexadecimal and Greek letters, and performs space and comma corrections. Big marks in numbers are removed. HTML tags <sup> and <sub> are converted to '^' and '_' respectively. All other HTML tags are removed.
}
\examples{
# Example matrix
m<-rbind(c("","ß","Standard Error","Pr(>|t|)"),
         c("(Intercept)","1,234.5","123.4","1.3e-4"),
         c("Variable 1","1,2",".04","2.4*10^-5"),
         c("R^2",".23","*","-"))
m

# apply function
unifyMatrixContent(m, correctComma = TRUE)
}
