% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_info.R
\name{make_info}
\alias{make_info}
\title{Make an info structure with tag metadata}
\usage{
make_info(depid, tagtype, species, owner)
}
\arguments{
\item{depid}{Deployment id string for this tag record}

\item{tagtype}{String identifying the tag type, for example 'dtag', 'cats', 'mk10', ...}

\item{species}{(optional) 2-letter string with the first letters of the species binomial}

\item{owner}{(optional) String with initials of the tag data owner}
}
\value{
A list containing metadata for a tag deployment. It's recommended to name this output "info" and save it as part of a netCDF tag data archive file (along with the tag sensor data).
}
\description{
This function allows the user to generate a "skeleton" info structure for a tag deployment, with some common pieces of metadata filled in. Additional information can then be added manually or using a custom script before saving this \code{info} as part of a netCDF file.
}
\examples{
info <- make_info("d4_template", "dtag4", "zc", "sdr")

}
