% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_grf.R
\name{learner_grf}
\alias{learner_grf}
\title{Construct a learner}
\usage{
learner_grf(
  formula,
  num.trees = 2000,
  min.node.size = 5,
  alpha = 0.05,
  sample.fraction = 0.5,
  num.threads = 1,
  model = "grf::regression_forest",
  info = model,
  learner.args = NULL,
  ...
)
}
\arguments{
\item{formula}{(formula) Formula specifying response and design matrix.}

\item{num.trees}{Number of trees grown in the forest. Note: Getting accurate
confidence intervals generally requires more trees than
getting accurate predictions. Default is 2000.}

\item{min.node.size}{A target for the minimum number of observations in each tree leaf. Note that nodes
with size smaller than min.node.size can occur, as in the original randomForest package.
Default is 5.}

\item{alpha}{A tuning parameter that controls the maximum imbalance of a split. Default is 0.05.}

\item{sample.fraction}{Fraction of the data used to build each tree.
Note: If honesty = TRUE, these subsamples will
further be cut by a factor of honesty.fraction. Default is 0.5.}

\item{num.threads}{Number of threads used in training. By default, the number of threads is set
to the maximum hardware concurrency.}

\item{model}{(character) grf model to estimate. Usually regression_forest
(\link[grf:regression_forest]{grf::regression_forest}) or probability_forest (\link[grf:probability_forest]{grf::probability_forest}).}

\item{info}{(character) Optional information to describe the instantiated
\link{learner} object.}

\item{learner.args}{(list) Additional arguments to
\link[=learner]{learner$new()}.}

\item{...}{Additional arguments to \code{model}}
}
\value{
\link{learner} object.
}
\description{
Constructs a \link{learner} class object for fitting generalized
random forest models with \link[grf:regression_forest]{grf::regression_forest} or
\link[grf:probability_forest]{grf::probability_forest}. As shown in the examples, the constructed learner
returns predicted class probabilities of class 2 in case of binary
classification. A \verb{n times p} matrix, with \code{n} being the number of
observations and \code{p} the number of classes, is returned for multi-class
classification.
}
\examples{
n <- 5e2
x1 <- rnorm(n, sd = 2)
x2 <- rnorm(n)
lp <- x2*x1 + cos(x1)
yb <- rbinom(n, 1, lava::expit(lp))
y <-  lp + rnorm(n, sd = 0.5**.5)
d <- data.frame(y, yb, x1, x2)

# regression
lr <- learner_grf(y ~ x1 + x2)
lr$estimate(d)
lr$predict(head(d))

# binary classification
lr <- learner_grf(as.factor(yb) ~ x1 + x2, model = "probability_forest")
lr$estimate(d)
lr$predict(head(d)) # predict class probabilities of class 2

# multi-class classification
lr <- learner_grf(Species ~ ., model = "probability_forest")
lr$estimate(iris)
lr$predict(head(iris))
}
