% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_igraph.R
\name{tar_igraph}
\alias{tar_igraph}
\title{Get the igraph.}
\usage{
tar_igraph(
  targets_only = FALSE,
  callr_function = callr::r,
  callr_arguments = targets::tar_callr_args_default(callr_function),
  envir = parent.frame(),
  script = targets::tar_config_get("script")
)
}
\arguments{
\item{targets_only}{\code{TRUE} to restrict the output to just
the actual targets in the pipeline, \code{FALSE} to include
imported global functions and objects as well.}

\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}

\item{envir}{An environment, where to run the target R script
(default: \verb{_targets.R}) if \code{callr_function} is \code{NULL}.
Ignored if \code{callr_function} is anything other than \code{NULL}.
\code{callr_function} should only be \code{NULL} for debugging and
testing purposes, not for serious runs of a pipeline, etc.

The \code{envir} argument of \code{\link[=tar_make]{tar_make()}} and related
functions always overrides
the current value of \code{tar_option_get("envir")} in the current R session
just before running the target script file,
so whenever you need to set an alternative \code{envir}, you should always set
it with \code{tar_option_set()} from within the target script file.
In other words, if you call \code{tar_option_set(envir = envir1)} in an
interactive session and then
\code{tar_make(envir = envir2, callr_function = NULL)},
then \code{envir2} will be used.}

\item{script}{Character of length 1, path to the
target script file. Defaults to \code{tar_config_get("script")},
which in turn defaults to \verb{_targets.R}. When you set
this argument, the value of \code{tar_config_get("script")}
is temporarily changed for the current function call.
See \code{\link[=tar_script]{tar_script()}},
\code{\link[=tar_config_get]{tar_config_get()}}, and \code{\link[=tar_config_set]{tar_config_set()}} for details
about the target script file and how to set it
persistently for a project.}
}
\value{
An \code{igraph} object with the dependency graph.
}
\description{
Return an igraph object with the dependency graph
of the pipeline.
}
\details{
If you have \code{igraph} >= 2.2.0 installed, then you can debug
cycles in your pipeline by running \code{igraph::find_cycle(tar_igraph())}.
This helps detect cycles in the dependency graph of the pipeline.
A cycle happens when a target directly or indirectly depends on itself,
which is not allowed. \code{igraph::find_cycle()} returns a character vector
of the names of the targets and objects involved in the cycle
(if a cycle exists).
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
  tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
    tar_script(
      list(
        tar_target(x, 1),
        tar_target(y, 2)
      ),
      ask = FALSE
    )
    tar_igraph()
  })
}
}
\seealso{
Other inspect: 
\code{\link{tar_deps}()},
\code{\link{tar_manifest}()},
\code{\link{tar_network}()},
\code{\link{tar_outdated}()},
\code{\link{tar_sitrep}()},
\code{\link{tar_validate}()}
}
\concept{inspect}
