% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_types.R
\name{variable_types}
\alias{variable_types}
\title{Get classes of selected columns from dataset}
\usage{
variable_types(data, columns = NULL)
}
\arguments{
\item{data}{(\code{data.frame} or \code{DataFrame} or \code{matrix}) Object in which to determine variable types.}

\item{columns}{(\code{character}) Vector of columns in \code{data} for which to get types.
Set to \code{NULL} to get types of all columns.}
}
\value{
Character vector of classes of \code{columns} from provided \code{data}.
}
\description{
Get classes of selected columns from dataset
}
\examples{
# use non-exported function from teal.slice
variable_types <- getFromNamespace("variable_types", "teal.slice")

variable_types(
  data.frame(
    x = 1:3, y = factor(c("a", "b", "a")), z = c("h1", "h2", "h3"),
    stringsAsFactors = FALSE
  ),
  "x"
)

variable_types(
  data.frame(
    x = 1:3, y = factor(c("a", "b", "a")), z = c("h1", "h2", "h3"),
    stringsAsFactors = FALSE
  ),
  c("x", "z")
)

variable_types(
  data.frame(
    x = 1:3, y = factor(c("a", "b", "a")), z = c("h1", "h2", "h3"),
    stringsAsFactors = FALSE
  )
)

}
\keyword{internal}
