% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{sample_median}
\alias{sample_median}
\alias{circular_sample_median}
\alias{circular_sample_median_deviation}
\title{Sample Circular Median and Deviation}
\usage{
circular_sample_median(x, axial = TRUE, na.rm = TRUE)

circular_sample_median_deviation(x, axial = TRUE, na.rm = TRUE)
}
\arguments{
\item{x}{numeric vector. Values in degrees.}

\item{axial}{logical. Whether the data are axial, i.e. pi-periodical
(\code{TRUE}, the default) or directional, i.e. \eqn{2 \pi}-periodical (\code{FALSE}).}

\item{na.rm}{logical value indicating whether \code{NA} values in \code{x}
should be stripped before the computation proceeds.}
}
\value{
numeric
}
\description{
Sample median direction for a vector of circular data
}
\examples{
set.seed(1)
x <- rvm(n = 100, mean = 0, kappa = 10)
circular_sample_median(x)
circular_sample_median_deviation(x)

data("san_andreas")
circular_sample_median(san_andreas$azi)
circular_sample_median_deviation(san_andreas$azi)
}
\references{
N.I. Fisher (1993) Statistical Analysis of Circular Data, Cambridge University Press.
}
