% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_cols_by_groups.R
\name{combine_groups}
\alias{combine_groups}
\title{Reference and treatment group combination}
\usage{
combine_groups(fct, ref = NULL, collapse = "/")
}
\arguments{
\item{fct}{(\code{factor})\cr the variable with levels which needs to be grouped.}

\item{ref}{(\code{character})\cr the reference level(s).}

\item{collapse}{(\code{string})\cr a character string to separate \code{fct} and \code{ref}.}
}
\value{
A \code{list} with first item \code{ref} (reference) and second item \code{trt} (treatment).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Facilitate the re-combination of groups divided as reference and treatment groups; it helps in arranging groups of
columns in the \code{rtables} framework and teal modules.
}
\examples{
groups <- combine_groups(
  fct = DM$ARM,
  ref = c("B: Placebo")
)

basic_table() \%>\%
  split_cols_by_groups("ARM", groups) \%>\%
  add_colcounts() \%>\%
  analyze_vars("AGE") \%>\%
  build_table(DM)

}
