% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskdiff.R
\name{control_riskdiff}
\alias{control_riskdiff}
\title{Control function for risk difference column}
\usage{
control_riskdiff(
  arm_x = NULL,
  arm_y = NULL,
  format = "xx.x (xx.x - xx.x)",
  col_label = "Risk Difference (\%) (95\% CI)",
  pct = TRUE
)
}
\arguments{
\item{arm_x}{(\code{string})\cr name of reference arm to use in risk difference calculations.}

\item{arm_y}{(\code{character})\cr names of one or more arms to compare to reference arm in risk difference
calculations. A new column will be added for each value of \code{arm_y}.}

\item{format}{(\code{string} or \code{function})\cr the format label (string) or formatting function to apply to the risk
difference statistic. See the \verb{3d} string options in \code{\link[formatters:list_formats]{formatters::list_valid_format_labels()}} for possible format
strings. Defaults to \code{"xx.x (xx.x - xx.x)"}.}

\item{col_label}{(\code{character})\cr labels to use when rendering the risk difference column within the table.
If more than one comparison arm is specified in \code{arm_y}, default labels will specify which two arms are
being compared (reference arm vs. comparison arm).}

\item{pct}{(\code{flag})\cr whether output should be returned as percentages. Defaults to \code{TRUE}.}
}
\value{
A \code{list} of items with names corresponding to the arguments.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Sets a list of parameters to use when generating a risk (proportion) difference column. Used as input to the
\code{riskdiff} parameter of \code{\link[=tabulate_rsp_subgroups]{tabulate_rsp_subgroups()}} and \code{\link[=tabulate_survival_subgroups]{tabulate_survival_subgroups()}}.
}
\examples{
control_riskdiff()
control_riskdiff(arm_x = "ARM A", arm_y = "ARM B")

}
\seealso{
\code{\link[=add_riskdiff]{add_riskdiff()}}, \code{\link[=tabulate_rsp_subgroups]{tabulate_rsp_subgroups()}}, and \code{\link[=tabulate_survival_subgroups]{tabulate_survival_subgroups()}}.
}
