% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_diff_test.R
\name{h_prop_diff_test}
\alias{h_prop_diff_test}
\alias{prop_chisq}
\alias{prop_cmh}
\alias{prop_schouten}
\alias{prop_fisher}
\title{Helper functions to test proportion differences}
\usage{
prop_chisq(tbl, alternative = c("two.sided", "less", "greater"))

prop_cmh(
  ary,
  alternative = c("two.sided", "less", "greater"),
  transform = c("none", "wilson_hilferty")
)

prop_schouten(tbl, alternative = c("two.sided", "less", "greater"))

prop_fisher(tbl, alternative = c("two.sided", "less", "greater"))
}
\arguments{
\item{tbl}{(\code{matrix})\cr matrix with two groups in rows and the binary response (\code{TRUE}/\code{FALSE}) in columns.}

\item{alternative}{(\code{string})\cr whether \code{two.sided}, or one-sided \code{less} or \code{greater} p-value
should be displayed.}

\item{ary}{(\code{array}, 3 dimensions)\cr array with two groups in rows, the binary response
(\code{TRUE}/\code{FALSE}) in columns, and the strata in the third dimension.}

\item{transform}{(\code{string})\cr either \code{none} or \code{wilson_hilferty}; specifies whether to apply
the Wilson-Hilferty transformation of the chi-squared statistic.}
}
\value{
A p-value.
}
\description{
Helper functions to implement various tests on the difference between two proportions.
}
\section{Functions}{
\itemize{
\item \code{prop_chisq()}: Performs Chi-Squared test. Internally calls \code{\link[stats:prop.test]{stats::prop.test()}}.

\item \code{prop_cmh()}: Performs stratified Cochran-Mantel-Haenszel test,
using \code{\link[stats:mantelhaen.test]{stats::mantelhaen.test()}} internally.
Note that strata with less than two observations are automatically discarded.

\item \code{prop_schouten()}: Performs the Chi-Squared test with Schouten correction.

\item \code{prop_fisher()}: Performs the Fisher's exact test. Internally calls \code{\link[stats:fisher.test]{stats::fisher.test()}}.

}}
\seealso{
\code{\link[=prop_diff_test]{prop_diff_test()}} for implementation of these helper functions.

Schouten correction is based upon \insertCite{Schouten1980-kd;textual}{tern}.
}
\keyword{internal}
