% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfm.R, R/um.R
\name{sim.tfm}
\alias{sim.tfm}
\alias{sim}
\alias{sim.um}
\title{Simulate Time Series from ARIMA or Transfer Function Models}
\usage{
\method{sim}{tfm}(
  mdl,
  n = 100,
  z0 = NULL,
  n0 = 0,
  a = NULL,
  seed = NULL,
  envir = parent.frame(),
  ...
)

sim(mdl, ...)

\method{sim}{um}(
  mdl,
  n = 100,
  z0 = NULL,
  n0 = 0,
  a = NULL,
  seed = NULL,
  envir = parent.frame(),
  ...
)
}
\arguments{
\item{mdl}{An object of class \code{\link{um}} or \code{\link{tfm}}.}

\item{n}{Number of observations to simulate.}

\item{z0}{Initial conditions for nonstationary series. Default is \code{NULL} (zero initial conditions).}

\item{n0}{Number of initial observations to discard as burn-in. Default is \code{0}.}

\item{a}{Optional vector of innovations with length \code{n + n0}. If \code{NULL}, 
innovations are drawn from \eqn{N(0, \sigma^2)}.}

\item{seed}{Random seed for reproducibility.}

\item{envir}{Environment for argument evaluation. Default is \code{parent.frame()}.}

\item{...}{Additional arguments.}
}
\value{
A \code{ts} object with the simulated time series.
}
\description{
Generates random time series from ARIMA (\code{um}) or transfer function (\code{tfm}) models.
}
\examples{
# AR(1) model
mdl1 <- um(ar = "1 - 0.8B", sig2 = 1)
z1 <- sim(mdl1, n = 100, seed = 123)

# ARIMA(0,1,1) with burn-in
mdl2 <- um(i = 1, ma = "1 - 0.5B", sig2 = 1)
z2 <- sim(mdl2, n = 100, n0 = 50, seed = 456)

}
\seealso{
\code{\link{sim.um}}, \code{\link{sim.tfm}}
}
