% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm.R
\name{ssm}
\alias{ssm}
\title{Time Invariant State Space Model}
\usage{
ssm(z, b, C, S, xreg = NULL, bc = FALSE, cform = TRUE, tol = 1e-05)
}
\arguments{
\item{z}{an object of class \code{ts}.}

\item{b}{vector of coefficients (m-dimensional).}

\item{C}{matrix of coefficients (m x m).}

\item{S}{covariance matrix of the error vector [u(t), v(t)], (m+1 x m+1).}

\item{xreg}{design matrix of regressors.}

\item{bc}{logical. If TRUE logs are taken.}

\item{cform}{logical. If TRUE state equation is given in contemporaneous
form, otherwise it is written in lagged form.}

\item{tol}{tolerance to check if a value is zero or one.}
}
\value{
An object of class \code{ssm} containing:
\item{z}{the input time series}
\item{b}{observation coefficients}
\item{C}{state transition matrix}
\item{S}{error covariance matrix}
\item{xreg}{regressor matrix (if provided)}
\item{a}{regression coefficients for xreg (if computed)}
\item{z.name}{name of the input series}
\item{bc}{Box-Cox transformation indicator}
\item{m}{number of state variables}
\item{cform}{form indicator (contemporaneous vs lagged)}
\item{is.adm}{admissibility flag}
}
\description{
\code{ssm} creates an S3 object representing a time-invariant state space
model:
}
\details{
z(t) = b'x(t-j) + u(t) (observation equation), 
x(t) = Cx(t-1) + v(t) (state equation),
j = 0 for contemporaneous form or j = 1 for lagged form. 
Note: the lagged form (j=1) is equivalent to the future form 
x(t+1) = Cx(t) + v(t+1).
}
\examples{
# Local level model
b <- 1
C <- as.matrix(1)
ssm1 <- ssm(Nile, b, C, S = diag(c(irr = 1, lvl = 0.5)) )
ssm1

}
\references{
Durbin, J. and Koopman, S.J. (2012) Time Series Analysis by State Space
Methods, 2nd ed., Oxford University Press, Oxford.

Harvey, A.C. (1989) Forecasting, Structural Time Series Models and the Kalman
Filter. Cambridge University Press, Cambridge.
}
