% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precipitation-indices.R
\name{calculate_CWD}
\alias{calculate_CWD}
\title{Calculate consecutive wet days (CWD)}
\usage{
calculate_CWD(
  df,
  frequency = "daily",
  time_col = NULL,
  prcp_col = NULL,
  precip_col = NULL,
  wet_threshold = 1
)
}
\arguments{
\item{df}{Data frame with precipitation data}

\item{frequency}{Temporal frequency: "daily" or "hourly" (string)}

\item{time_col}{Name of the time column (string). Must be in a format recognizable by lubridate
(e.g., Date for daily data, POSIXct for hourly data). Recommended formats:
- Daily: YYYY-MM-DD (e.g., "2023-01-15")
- Hourly: YYYY-MM-DD HH:MM:SS (e.g., "2023-01-15 14:30:00")}

\item{prcp_col}{Name of precipitation column (daily data) (string)}

\item{precip_col}{Name of precipitation column (hourly data) (string)}

\item{wet_threshold}{Threshold for wet day in mm (default: 1)}
}
\value{
A data.frame with columns: year, CWD_max, CWD_mean, CWD_median, n_wet_spells
}
\description{
Calculates statistics for wet spells (consecutive days with
precipitation \eqn{\geq} 1 mm), following ETCCDI definition CWD.
}
\examples{
# Daily precipitation data
daily_prcp <- data.frame(
  date = seq(as.Date("2000-01-01"), as.Date("2002-12-31"), by = "day"),
  rainfall = pmax(0, rgamma(1096, shape = 0.5, scale = 10))
)

# Calculate consecutive wet days statistics
calculate_CWD(
  df = daily_prcp,
  frequency = "daily",
  time_col = "date",
  prcp_col = "rainfall"
)

# With custom wet threshold (5mm instead of 1mm)
calculate_CWD(
  df = daily_prcp,
  frequency = "daily",
  time_col = "date",
  prcp_col = "rainfall",
  wet_threshold = 5
)
}
