% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised-market-basket.R
\name{tidy_apriori}
\alias{tidy_apriori}
\title{Tidy Apriori Algorithm}
\usage{
tidy_apriori(
  transactions,
  support = 0.01,
  confidence = 0.5,
  minlen = 2,
  maxlen = 10,
  target = "rules"
)
}
\arguments{
\item{transactions}{A transactions object or data frame}

\item{support}{Minimum support (default: 0.01)}

\item{confidence}{Minimum confidence (default: 0.5)}

\item{minlen}{Minimum rule length (default: 2)}

\item{maxlen}{Maximum rule length (default: 10)}

\item{target}{Type of association mined: "rules" (default), "frequent itemsets", "maximally frequent itemsets"}
}
\value{
A list of class "tidy_rules" containing:
\itemize{
\item rules_tbl: tibble of rules with lhs, rhs, and quality measures
\item rules: original rules object
\item parameters: parameters used
}
}
\description{
Mine association rules using the Apriori algorithm with tidy output
}
\examples{
\donttest{
data("Groceries", package = "arules")

# Basic apriori
rules <- tidy_apriori(Groceries, support = 0.001, confidence = 0.5)

# Access rules
rules$rules_tbl
}

}
