% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_snmf.R
\name{gt_snmf}
\alias{gt_snmf}
\title{Run SNMF from R in tidypopgen}
\usage{
gt_snmf(
  x,
  k,
  project = "continue",
  n_runs = 1,
  alpha,
  tolerance = 1e-05,
  entropy = FALSE,
  percentage = 0.05,
  I,
  iterations = 200,
  ploidy = 2,
  seed = -1
)
}
\arguments{
\item{x}{a \code{gen_tibble} or a character giving the path to the input geno file}

\item{k}{an integer giving the number of clusters}

\item{project}{one of "continue", "new", and "force": "continue" stores files
in the current project, "new" creates a new project, and "force" stores
results in the current project even if the .geno input file has been
altered,}

\item{n_runs}{the number of runs for each k value (defaults to 1)}

\item{alpha}{numeric snmf regularization parameter. See LEA::snmf for details}

\item{tolerance}{numeric value of tolerance (default 0.00001)}

\item{entropy}{boolean indicating whether to estimate cross-entropy}

\item{percentage}{numeric value indicating percentage of masked genotypes,
ranging between 0 and 1, to be used when entropy = TRUE}

\item{I}{number of SNPs for initialising the snmf algorithm}

\item{iterations}{numeric integer for maximum iterations (default 200)}

\item{ploidy}{the ploidy of the input data (defaults to 2)}

\item{seed}{the seed for the random number generator}
}
\value{
an object of class \code{gt_admix} consisting of a list with the following
elements:
\itemize{
\item \code{k} the number of clusters
\item \code{Q} a matrix with the admixture proportions
\item \code{P} a matrix with the allele frequencies
\item \code{log} a log of the output generated by ADMIXTURE (usually printed
on the screen when running from the command line)
\item \code{cv} the masked cross-entropy (if \code{entropy} is TRUE)
\item \code{loglik} the log likelihood of the model
\item \code{id} the id column of the input \code{gen_tibble} (if applicable)
\item \code{group} the group column of the input \code{gen_tibble} (if applicable)
}
}
\description{
Run SNMF from R in tidypopgen
}
\details{
This is a wrapper for \code{\link[LEA:main_sNMF]{LEA::snmf()}}.
}
\examples{
\dontshow{if (rlang::is_installed("LEA")) withAutoprint(\{ # examplesIf}
# run the example only if we have the package installed
example_gt <- load_example_gt("gen_tbl")

# To run SNMF on a gen_tibble:
example_gt \%>\% gt_snmf(
  k = 1:3, project = "force", entropy = TRUE,
  percentage = 0.5, n_runs = 1, seed = 1, alpha = 100
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[LEA:main_sNMF]{LEA::snmf()}}
}
