% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm_feedback.R
\name{llm_feedback}
\alias{llm_feedback}
\title{Create an \code{llm_feedback} object}
\usage{
llm_feedback(text, tool_result = FALSE)
}
\arguments{
\item{text}{A character string containing the feedback text. This will
be sent back to the LLM after not passing an extractor or validator function}

\item{tool_result}{A logical indicating whether the feedback is a tool result.
If TRUE, \code{\link[=send_prompt]{send_prompt()}} will not remove it from the chat history when
cleaning the context window during repeated interactions}
}
\value{
An object of class "llm_feedback" (or "llm_feedback_tool_result")
containing the feedback text to send back to the LLM
}
\description{
This object is used to send feedback to a LLM when a LLM reply
does not succesfully pass an extraction or validation function
(as handled by \code{\link[=send_prompt]{send_prompt()}} and defined using \code{\link[=prompt_wrap]{prompt_wrap()}}).
The feedback text is sent back to the LLM. The extraction or validation function
should then return this object with the feedback text that should be sent to the LLM.
}
\examples{
# Example usage within a validation function similar to the one in 'answer_as_integer()':
validation_fn <- function(x, min = 0, max = 100) {
  if (x != floor(x)) {
    # Not a whole number
    return(llm_feedback(
      "You must answer with only an integer (use no other characters)."
    ))
  }
  if (!is.null(min) && x < min) {
    return(llm_feedback(glue::glue(
      "The number should be greater than or equal to {min}."
    )))
  }
  if (!is.null(max) && x > max) {
    return(llm_feedback(glue::glue(
      "The number should be less than or equal to {max}."
    )))
  }
  return(TRUE)
}

# This validation_fn would be part of a prompt_wrap();
#   see the `answer_as_integer()` function for an example of how to use it
}
\seealso{
\code{\link[=llm_break]{llm_break()}}

Other prompt_wrap: 
\code{\link{llm_break}()},
\code{\link{prompt_wrap}()}

Other prompt_evaluation: 
\code{\link{llm_break}()},
\code{\link{send_prompt}()}
}
\concept{prompt_evaluation}
\concept{prompt_wrap}
