% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm_providers.R
\name{llm_provider_ollama}
\alias{llm_provider_ollama}
\title{Create a new Ollama LLM provider}
\usage{
llm_provider_ollama(
  parameters = list(model = "llama3.1:8b", stream = getOption("tidyprompt.stream", TRUE)),
  verbose = getOption("tidyprompt.verbose", TRUE),
  url = "http://localhost:11434/api/chat",
  num_ctx = NULL
)
}
\arguments{
\item{parameters}{A named list of parameters. Currently the following parameters are required:
\itemize{
\item model: The name of the model to use
\item stream: A logical indicating whether the API should stream responses
}

Additional parameters may be passed by adding them to the parameters list;
these parameters will be passed to the Ollama API via the body of the POST request.

Note that various Ollama options need to be set in a list named 'options' within
the parameters list (e.g., context window size is represented in $parameters$options$num_ctx).
For ease of configuration, the 'set_option' and 'set_options' functions are available
(e.g., \verb{$set_option("num_ctx", 1024)} or \verb{$set_options(list(num_ctx = 1024, temperature = 1))}).}

\item{verbose}{A logical indicating whether the interaction with the LLM provider
should be printed to the console}

\item{url}{The URL to the Ollama API endpoint for chat completion
(typically: "http://localhost:11434/api/chat")}

\item{num_ctx}{The context window size to use.
When NULL, the default context window size will be used. This is a function
argument for convenience, and will be passed to '$parameters$options$num_ctx'}
}
\value{
A new \linkS4class{llm_provider} object for use of the Ollama API
}
\description{
This function creates a new \linkS4class{llm_provider} object that interacts with the Ollama API.
}
\examples{
# Various providers:
ollama <- llm_provider_ollama()
openai <- llm_provider_openai()
openrouter <- llm_provider_openrouter()
mistral <- llm_provider_mistral()
groq <- llm_provider_groq()
xai <- llm_provider_xai()
gemini <- llm_provider_google_gemini()

# From an `ellmer::chat()` (e.g., `ellmer::chat_openai()`, ...):
\dontrun{
ellmer <- llm_provider_ellmer(ellmer::chat_openai())
}

# Initialize with settings:
ollama <- llm_provider_ollama(
  parameters = list(
    model = "llama3.2:3b",
    stream = TRUE
  ),
  verbose = TRUE,
  url = "http://localhost:11434/api/chat"
)

# Change settings:
ollama$verbose <- FALSE
ollama$parameters$stream <- FALSE
ollama$parameters$model <- "llama3.1:8b"

\dontrun{
# Try a simple chat message with '$complete_chat()':
response <- ollama$complete_chat("Hi!")
response
# $role
# [1] "assistant"
#
# $content
# [1] "How's it going? Is there something I can help you with or would you like
# to chat?"
#
# $http
# Response [http://localhost:11434/api/chat]
# Date: 2024-11-18 14:21
# Status: 200
# Content-Type: application/json; charset=utf-8
# Size: 375 B

# Use with send_prompt():
"Hi" |>
  send_prompt(ollama)
# [1] "How's your day going so far? Is there something I can help you with or
# would you like to chat?"
}
}
\seealso{
Other llm_provider: 
\code{\link{llm_provider-class}},
\code{\link{llm_provider_ellmer}()},
\code{\link{llm_provider_google_gemini}()},
\code{\link{llm_provider_groq}()},
\code{\link{llm_provider_mistral}()},
\code{\link{llm_provider_openai}()},
\code{\link{llm_provider_openrouter}()},
\code{\link{llm_provider_xai}()}
}
\concept{llm_provider}
