% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_lm.R
\name{sample_lm}
\alias{sample_lm}
\title{Sample the conditional distribution created by a linear model}
\usage{
sample_lm(model, new_data, conf_data)
}
\arguments{
\item{model}{A "model_fit" object created by parsnip::linear_reg()}

\item{new_data}{A data frame with predictors}

\item{conf_data}{A data frame with original confidential predictors}
}
\value{
A numeric vector of predictions
}
\description{
Sample the conditional distribution created by a linear model
}
\examples{

lm_mod <- parsnip::linear_reg() |>
  parsnip::set_engine("lm") |>
  parsnip::set_mode(mode = "regression")

regression_rec <- recipes::recipe(inctot ~ ., data = acs_conf)

model_reg <- workflows::workflow() |>
  workflows::add_model(spec = lm_mod) |>
  workflows::add_recipe(recipe = regression_rec) |>
  parsnip::fit(data = acs_conf)

set.seed(1)
sample1 <- sample_lm(
  model = model_reg, 
  new_data = acs_conf[1:3, ], 
  conf_data = acs_conf
)

}
