% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statlist.R
\name{statlist}
\alias{statlist}
\title{Create a \code{statlist} interface for a table}
\usage{
statlist(stats, ...)
}
\arguments{
\item{stats}{(required) A character vector of statistics to display in the
table.}

\item{...}{(optional) Additional configuration for stats. See sections below
for allowable arguments.}
}
\value{
A \code{statlist} object that can be passed in the \code{statlist} argument of
\code{freq}, \code{nested_freq}, or \code{univar}.
}
\description{
The \code{statlist} is the interface for the presentation of data in a \code{tidytlg}
table.
}
\section{\code{Statlists} for \code{freq()} and \code{nested_freq()}}{

\code{freq()} \code{statlists} can be composed of \code{n} (count), \code{N} (denominator), and
\code{x.x} (percentage, formatted with or without a percent sign).
Denominators will include missing values if the 'display_missing'
argument is \code{TRUE}, otherwise they will be excluded. They can be arranged
in the following ways:
\itemize{
\item{\code{n}}
\item{\code{n/N}}
\item{\code{n (x.x)}}
\item{\verb{n (x.x\%)}}
\item{\code{n/N (x.x)}}
\item{\verb{n/N (x.x\%)}}
}

The following other configurations are supported:
\itemize{
\item{\code{denoms_by} - Controls what groupings of variables should define the
denominator. Variables should be passed as a quoted vector}
\item{\code{distinct} - A boolean value. Should the numerator reflect distinct
\code{USUBJIDs} or event counts. Defaults to \code{TRUE} which captures distinct
subjects.}
\item{\code{distinct_by} - A character value used to select the variable that
should be used to "distinct" the frequency tables. Defaults to \code{USUBJID}.}
\item{\code{zero_denom} - The string to display when there are no records found
in an entire denominator group. Defaults to \code{-}}
\item{\code{zero_n} - The string to display when there are no records found for
a numerator. Defaults to \code{0}.}
}
}

\section{\code{Statlists} for \code{univar} \code{statlists}}{

\itemize{
\item{\code{N}}
\item{\code{SUM}}
\item{\code{MEAN}}
\item{\code{GeoMEAN}}
\item{\code{SD}}
\item{\code{SE}}
\item{\code{CV}}
\item{\code{GSD}}
\item{\code{GSE}}
\item{\code{MEANSD}}
\item{\code{MEANSE}}
\item{\code{MEDIAN}}
\item{\code{MIN}}
\item{\code{MAX}}
\item{\code{RANGE}}
\item{\code{Q1}}
\item{\code{Q3}}
\item{\code{IQRANGE}}
\item{\code{MEDRANGE}}
\item{\code{MEDIQRANGE}}
\item{\code{MEAN_CI}}
\item{\code{GeoMEAN_CI}}
}

where \code{GeoMEAN}: Geometric Mean, \code{CV}: Coefficient of Variation,
\code{GSD}: Geometric standard deviation, \code{GSE}: Geometric standard error,
\code{MEAN_CI}: Mean (95\% C.I.), \code{GeoMEAN_CI}: Geometric Mean (95\% C.I.).
In calculating geometric statistics, if there
are zero values in the inputs, zero values will be excluded before
calculating geometric statistics.
}

\examples{

freq(
  mtcars,
  colvar = "gear",
  rowvar = "cyl",
  rowbyvar = "am",
  statlist = statlist("n/N (x.x)",
    distinct = FALSE,
    denoms_by = c("gear", "am"),
    zero_denom = "_0_"
  )
)
}
