% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{table_metadata}
\alias{table_metadata}
\title{Metadata describing the data, functions and arguments needed to produce your
results.}
\format{
A data frame with one row per function call and 16 variables:
\describe{
\item{\code{func}}{name of the function you wish to call}
\item{\code{df}}{data frame to pass to the function call}
\item{\code{subset}}{filter \code{df} records, this is passed directly to filter,
ex. \code{"AESER == 'Y'"}}
\item{\code{rowvar}}{variable being summarized that will pass to the function
call}
\item{\code{rowtext}}{row label text to display in the table}
\item{\code{row_header}}{header text to display above row summary}
\item{\code{statlist}}{list of statistics in the analysis, see individual
functions for what is available per function (e.g. \code{"N, n (x.x)"})}
\item{\code{colvar}}{variable used to determine the columns of the table}
\item{\code{decimal}}{decimal precision}
\item{\code{rowbyvar}}{repeat \code{rowvar} summary by this variable/s, comma separated
for multiple (e.g. \code{"ETHNIC, AGEGR1"})}
\item{\code{tablebyvar}}{repeat the entire table summary by this variable/s,
comma separated for multiple (e.g. \code{"ETHNIC, AGEGR1"})}
\item{\code{denom_df}}{used to set denominators if \code{df} does not contain
all required records}
}
}
\usage{
table_metadata
}
\description{
Metadata describing the data, functions and arguments needed to produce your
results.
}
\keyword{datasets}
