% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_wikipedia_page_section_links.R
\name{tw_get_wikipedia_page_section_links}
\alias{tw_get_wikipedia_page_section_links}
\title{Get links from a specific section of a Wikipedia page}
\usage{
tw_get_wikipedia_page_section_links(
  url = NULL,
  title = NULL,
  section_title = NULL,
  section_index = NULL,
  language = tidywikidatar::tw_get_language(),
  cache = NULL,
  overwrite_cache = FALSE,
  cache_connection = NULL,
  disconnect_db = TRUE,
  wait = 1,
  attempts = 10,
  wikipedia_page_qid_df = NULL
)
}
\arguments{
\item{url}{Full url to a Wikipedia page. If given, title and language can be
left empty.}

\item{title}{Title of a Wikipedia page or final parts of its url. If given,
url can be left empty, but language must be provided.}

\item{section_title}{Defaults to \code{NULL}. If given, it should correspond to
the human-readable title of a section of the relevant Wikipedia page. See
also \code{\link[=tw_get_wikipedia_page_sections]{tw_get_wikipedia_page_sections()}}}

\item{section_index}{Defaults to \code{NULL}. If given, it should correspond to
the ordinal of a section of the relevant Wikipedia page. See also
\code{\link[=tw_get_wikipedia_page_sections]{tw_get_wikipedia_page_sections()}}}

\item{language}{Defaults to language set with \code{\link[=tw_set_language]{tw_set_language()}}; if not
set, "en". Use "all_available" to keep all languages. For available
language values, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{the
dedicated Wikimedia page}.}

\item{cache}{Defaults to \code{NULL}. If given, it should be given either \code{TRUE}
or \code{FALSE}. Typically set with \code{\link[=tw_enable_cache]{tw_enable_cache()}} or \code{\link[=tw_disable_cache]{tw_disable_cache()}}.}

\item{overwrite_cache}{Logical, defaults to \code{FALSE}. If \code{TRUE}, it overwrites
the table in the local sqlite database. Useful if the original Wikidata
object has been updated.}

\item{cache_connection}{Defaults to \code{NULL}. If \code{NULL}, and caching is
enabled, \code{tidywikidatar} will use a local sqlite database. A custom
connection to other databases can be given (see vignette \code{caching} for
details).}

\item{disconnect_db}{Defaults to \code{TRUE}. If \code{FALSE}, leaves the connection to
cache open.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to
Wikidata. If data are cached locally, wait time is not applied. If you are
running many queries systematically you may want to add some waiting time
between queries.}

\item{attempts}{Defaults to 10. Number of times it re-attempts to reach the
API before failing.}

\item{wikipedia_page_qid_df}{Defaults to \code{NULL}. If given, used to reduce
calls to cache. Must be a data frame.}
}
\value{
A data frame (a tibble).
}
\description{
Get links from a specific section of a Wikipedia page
}
\examples{
if (interactive()) {
  tw_get_wikipedia_page_section_links(title = "Margaret Mead", language = "en", section_index = 1)
}
}
