% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsfwqi.R
\name{nsfwqi}
\alias{nsfwqi}
\title{NSF Water Quality Index (NSF WQI, prototype)}
\usage{
nsfwqi(
  df,
  pesos = c(do = 0.17, fc = 0.16, ph = 0.11, bod = 0.11, temp_change = 0.1, po4 = 0.1,
    no3 = 0.1, turbidez = 0.08, sst = 0.07),
  na_rm = FALSE
)
}
\arguments{
\item{df}{Data frame containing columns compatible with the mapping above.}

\item{pesos}{Named numeric vector with parameter weights. Defaults follow a
common NSF WQI variant:
\code{do=.17}, \code{fc=.16}, \code{ph=.11}, \code{bod=.11},
\code{temp_change=.10}, \code{po4=.10}, \code{no3=.10},
\code{turbidez=.08}, \code{sst=.07}.}

\item{na_rm}{Logical; allow NA per row and rescale weights to available
parameters (\code{TRUE}) or error on missing inputs (\code{FALSE}).}
}
\value{
The input \code{df} with an added numeric column \code{NSFWQI}.
}
\description{
Computes a \strong{prototype} NSF WQI as a weighted arithmetic mean of
parameter sub-scores (Qi) using simple piecewise rules. This is intended
for quick demonstrations and is \strong{not} a full replication of the original
NSF curves.
}
\details{
The function accepts both NSF-style column names and common Brazilian
aliases. The mapping tried (if present) is:
\itemize{
\item \code{do}  <- \code{od}
\item \code{fc}  <- \code{coliformes}
\item \code{ph}  <- \code{pH} or \code{ph}
\item \code{bod} <- \code{dbo}
\item \code{turbidez} stays \code{turbidez}
\item \code{sst} <- \code{solidos_suspensos}
\item \code{po4} <- \code{po4} or \code{p_ortofosfato}
\item \code{no3} <- \code{no3} or \code{n_nitrato}
\item \code{temp_change} must be supplied as-is (delta T to reference)
}

If \code{na_rm = TRUE}, weights are rescaled \strong{per row} to the parameters
available in that row. If \code{na_rm = FALSE} (default), any missing
required input leads to an error.
}
\examples{
d <- wq_demo
# create minimal aliases so the prototype can run
d$do  <- d$od
d$fc  <- d$coliformes
d$ph  <- d$ph
d$bod <- d$dbo
# others are missing; use na_rm = TRUE to rescale weights by row
out <- nsfwqi(d, na_rm = TRUE)
head(out$NSFWQI)

}
