% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_stream.R
\name{toon_stream_write_rows}
\alias{toon_stream_write_rows}
\title{Stream write tabular rows}
\usage{
toon_stream_write_rows(
  file,
  schema,
  row_source,
  batch_size = 10000L,
  indent = 2L
)
}
\arguments{
\item{file}{Character scalar. Path to output file.}

\item{schema}{Character vector of column names.}

\item{row_source}{Function that returns next batch as data.frame, or NULL
to end.}

\item{batch_size}{Integer. Hint for batch size (passed to row_source).}

\item{indent}{Integer. Number of spaces for indentation (default 2).}
}
\value{
Invisibly returns the number of rows written.
}
\description{
Stream write tabular rows
}
\details{
Writes a tabular TOON array without holding all rows in memory.
}
\examples{
\dontrun{
# Stream write rows
i <- 0
row_source <- function() {
  i <<- i + 1
  if (i > 3) return(NULL)
  data.frame(x = i, y = i * 2)
}
toon_stream_write_rows("output.toon",
  schema = c("x", "y"),
  row_source = row_source
)
}

}
