% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roads.R
\name{build_adjacency}
\alias{build_adjacency}
\title{Build segment adjacency from segment geometries}
\usage{
build_adjacency(segments, crs_m = 3857, tol = 0, verbose = FALSE)
}
\arguments{
\item{segments}{An `sf` with LINESTRING geometries and (optionally) `seg_id`.}

\item{crs_m}{Metric CRS used when `segments` is lon/lat (for robust node keys).
Default 3857.}

\item{tol}{Nonnegative numeric tolerance for snapping node coordinates (in meters
if projected). If 0, uses exact coordinates. Default 0.}

\item{verbose}{Logical; emit simple messages. Default FALSE.}
}
\value{
A list with:
\describe{
  \item{A}{Sparse symmetric adjacency matrix (`dgCMatrix`).}
  \item{components}{Integer vector component id (length n). Isolates are their own components.}
  \item{isolates}{Logical vector (length n).}
}
}
\description{
Constructs an undirected adjacency matrix `A` where segments are neighbors if
they share a node (endpoint). Intended to be used after `roads_to_segments()`.
}
\details{
Isolates (degree 0) are kept (all-zero rows/cols). Connected components are
returned for ICAR sum-to-zero centering per component.
}
