% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-headers.R
\name{parse_headers_collect}
\alias{parse_headers_collect}
\title{Parse a directory of headers and return named list of data.frames with}
\usage{
parse_headers_collect(
  dir = R.home("include"),
  recursive = TRUE,
  pattern = c("\\\\.h$", "\\\\.H$"),
  preprocess = FALSE,
  cc = r_cc(),
  ccflags = NULL,
  include_dirs = NULL,
  extract_params = FALSE,
  extract_return = FALSE,
  ...
)
}
\arguments{
\item{dir}{Directory to search for header files. Defaults to \code{R.home("include")}.}

\item{recursive}{Whether to search recursively for headers. Default \code{TRUE}.}

\item{pattern}{File name pattern to match header files. Default is \verb{\\.h$} and \verb{\\.H$}.}

\item{preprocess}{Run the C preprocessor (using R's configured CC) on header files before parsing. Defaults to \code{FALSE}.}

\item{cc}{The C compiler to use for preprocessing. If \code{NULL} the function queries \verb{R CMD config CC} and falls back to \code{Sys.getenv("CC")} and the \code{cc} on PATH.}

\item{ccflags}{Extra flags to pass to the compiler when preprocessing. If \code{NULL} flags are taken from \verb{R CMD config CFLAGS} and \verb{R CMD config CPPFLAGS}.}

\item{include_dirs}{Additional directories to add to the include path for preprocessing. A character vector of directories.}

\item{extract_params}{Logical; whether to extract parameter types for functions. Default \code{FALSE}.}

\item{extract_return}{Logical; whether to extract return types for functions. Default \code{FALSE}.}

\item{...}{Additional arguments passed to preprocess_header (e.g., extra compiler flags)}
}
\value{
A named list of data frames with components: \code{functions}, \code{structs}, \code{struct_members}, \code{enums}, \code{unions}, \code{globals}, \code{defines}.
}
\description{
functions, structs, struct members, enums, unions, globals, and macros.
}
\details{
This helper loops over headers found in a directory and returns a list
with tidy data.frames. Useful for programmatic analysis of header
collections.
}
\examples{
\dontrun{
if (requireNamespace("treesitter", quietly = TRUE)) {
  res <- parse_headers_collect(dir = R.home("include"), preprocess = FALSE)
  head(res$functions)
}
}
}
