% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{remove_class}
\alias{remove_class}
\title{Remove a \code{TSMP} class from an object}
\usage{
remove_class(x, class)
}
\arguments{
\item{x}{a \code{TSMP} object}

\item{class}{\code{character} string with the class name}
}
\value{
the object without the class
}
\description{
Remove a \code{TSMP} class from an object
}
\examples{
w <- 50
data <- mp_gait_data
mp <- tsmp(data, window_size = w, exclusion_zone = 1 / 4, verbose = 0)
mp <- find_chains(mp)
# Remove the "Chain" class information
mp <- remove_class(mp, "Chain")
}
