% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspredbench.R
\docType{data}
\name{m3}
\alias{m3}
\title{M3 Competition Time Series}
\format{
A list of lists containing time series.
}
\source{
\doi{10.1016/S0169-2070(00)00057-1}
}
\usage{
data(m3)
}
\description{
Time series data from the third Makridakis forecasting competition (M3), held in 2000.
Data Type: Forecasting benchmark dataset. Category: Forecasting. Creation Date: 2000.
}
\details{
Consolidated list keyed by frequency (e.g., \code{monthly}, \code{other}, \code{quarterly}, \code{yearly}). Each holds a list of numeric vectors.
See Makridakis & Hibon (2000) for competition results and implications.
}
\examples{
# Load consolidated M3 list and plot one monthly series
data(m3)
# m3 <- loadfulldata(m3)
series <- m3$monthly$M1
ts.plot(series, main = "M3 monthly series: M1")
}
\references{
Makridakis and Hibon (2000). The M3-Competition: Results, conclusions and implications. International Journal of Forecasting, 16(4), 451–476.
}
\keyword{datasets}
