% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tteICE.R
\name{plot.tteICE}
\alias{plot.tteICE}
\title{Plot method for 'tteICE' objects}
\usage{
\method{plot}{tteICE}(
  x,
  type = c("ate", "inc")[1],
  decrease = FALSE,
  conf.int = 0.95,
  xlab = "Time",
  xlim = NULL,
  ylim = NULL,
  plot.configs = list(),
  ...
)
}
\arguments{
\item{x}{A fitted object returned by the function \code{tteICE}, \code{surv.tteICE}, or \code{scr.tteICE}.}

\item{type}{Which plot to create: \code{type="ate"} indicates to plot the estimated treatment effects;
\code{type="inc"} indicates to plot the estimated cumulative incidence functions (CIFs).}

\item{decrease}{Corresponds to the argument in \code{\link[tteICE]{plot_ate}} and \code{\link[tteICE]{plot_inc}}.}

\item{conf.int}{#' Confidence level for the pointwise confidence intervals
If \code{conf.int = NULL}, no confidence intervals are provided.}

\item{xlab}{Label for the x-axis.}

\item{xlim}{A numeric vector of length 2 specifying the limits of the x-axis.
If \code{xlim=NULL} (default), the range is determined automatically from the data.}

\item{ylim}{A numeric vector of length 2 giving the limits of the y-axis.
If \code{ylim=NULL} (default), the range is determined automatically by the type of plot,
corresponding to the argument in \code{\link[tteICE]{plot_ate}} and \code{\link[tteICE]{plot_inc}}.}

\item{plot.configs}{A named \code{list} of additional plot configurations. See details in \code{\link{plot_ate}} and \code{\link{plot_inc}}}

\item{...}{Other arguments in function \code{\link{plot.default}} or function \code{\link{curve}}}
}
\value{
Plot the results from a tteICE object
}
\description{
This function plots the estimated potential cumulative incidence functions or treatment effect curve
with pointwise confidence intervals.
}
\examples{
## load data
data(bmt)
bmt = transform(bmt, d4=d2+d3)
A = as.numeric(bmt$group>1)
bmt$A = A

## simple model fitting and plotting
library(survival)
fit1 = tteICE(Surv(t2,d4,type = "mstate")~A, data=bmt)
plot(fit1, type="ate")
plot(fit1, type="inc")


## plot cumulative incidence functions with p-values
fit2 = surv.tteICE(A, bmt$t2, bmt$d4, "composite")
plot(fit2, type="inc", decrease=TRUE, ylim=c(0,1),
     plot.configs=list(show.p.value=TRUE))

## plot treatment effects for semicompeting risk data
fit3 = scr.tteICE(A, bmt$t1, bmt$d1, bmt$t2, bmt$d2, "composite")
plot(fit3, type="ate", ylim=c(-1,1), xlab="time",
     plot.configs=list(col="red"))


}
\seealso{
\code{\link[tteICE]{plot_ate}}, \code{\link[tteICE]{plot_inc}},
\code{\link[tteICE]{surv.tteICE}}, \code{\link[tteICE]{scr.tteICE}},
\code{\link[tteICE]{tteICE}}
}
