% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependency_graph.R
\name{plot_source_join_graph}
\alias{plot_source_join_graph}
\title{Plot a source join graph}
\usage{
plot_source_join_graph(joins_df, relationships_df = NULL, seed = NULL)
}
\arguments{
\item{joins_df}{Data frame with join edges.}

\item{relationships_df}{Optional data frame with modern relationships.}

\item{seed}{Optional integer seed to make layouts reproducible. If \code{NULL}
(default), the function preserves the caller's RNG state.}
}
\value{
Invisibly returns the join graph, or a list \code{list(joins = g, relationships = gr)}
if \code{relationships_df} is provided.
}
\description{
Visualizes joins between sources. Expects \code{joins_df} with columns
\code{left_table}, \code{right_table}, \code{left_field}, \code{right_field}. If
\code{relationships_df} is provided (modern relationships), it will render a
second graph highlighting those relationships.
}
