uncertaintyBudget.default <-
function(x, y, ...) {
	required.fields <- c("label", "name", "description", "mean", "unit", "u", 
		"type", "distribution", "dof")
	provided.fields <- names(x)
	mandatory <- match(provided.fields, required.fields)
	if (length(required.fields) != length(provided.fields)) {
		missing.fields <- c(1:length(required.fields))[-mandatory[!is.na(mandatory)]]
		stop(paste0("Required fields missing: ", 
			required.fields[missing.fields], "\n"))
	} else {
		# all required fields are provided, are there fields not required?
		notrequired.fields <- provided.fields[is.na(mandatory)]
		if (length(notrequired.fields) > 0) {
			warning(paste0("Ignoring not required fields: ", 
				notrequired.fields, "\n"))
		} #else 
		{
			# OK do your magic
			# ...
			colnames(y) <- rownames(y) <- x$name
			
			if (is.null(y)) y <- diag(1, length(x$name))
			res <- list(label = x$label, name = x$name, 
				description = x$description, mean = x$mean, unit = x$unit, 
				u = x$u, type = x$type, distribution = x$distribution, 
				dof = x$dof, cor = y)
			class(res) <- "uncertaintyBudget"
			return(res)
			#
		}
	}
}
