% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uwot.R
\name{optimize_graph_layout}
\alias{optimize_graph_layout}
\title{Optimize Graph Layout}
\usage{
optimize_graph_layout(
  graph,
  X = NULL,
  n_components = 2,
  n_epochs = NULL,
  learning_rate = 1,
  init = "spectral",
  init_sdev = NULL,
  spread = 1,
  min_dist = 0.01,
  repulsion_strength = 1,
  negative_sample_rate = 5,
  a = NULL,
  b = NULL,
  method = "umap",
  approx_pow = FALSE,
  pcg_rand = TRUE,
  fast_sgd = FALSE,
  n_sgd_threads = 0,
  grain_size = 1,
  verbose = getOption("verbose", TRUE),
  batch = FALSE,
  opt_args = NULL,
  epoch_callback = NULL,
  pca_method = NULL,
  binary_edge_weights = FALSE,
  rng_type = NULL
)
}
\arguments{
\item{graph}{A sparse, symmetric N x N weighted adjacency matrix
representing a graph. Non-zero entries indicate an edge between two nodes
with a given edge weight. There can be a varying number of non-zero entries
in each row/column.}

\item{X}{Optional input data. Used only for PCA-based initialization.}

\item{n_components}{The dimension of the space to embed into. This defaults
to \code{2} to provide easy visualization, but can reasonably be set to any
integer value in the range \code{2} to \code{100}.}

\item{n_epochs}{Number of epochs to use during the optimization of the
  embedded coordinates. By default, this value is set to \code{500} for
  datasets containing 10,000 vertices or less, and \code{200} otherwise.
  If \code{n_epochs = 0}, then coordinates determined by \code{"init"} will
  be returned.
For UMAP, the default is \code{"none"}.}

\item{learning_rate}{Initial learning rate used in optimization of the
coordinates.}

\item{init}{Type of initialization for the coordinates. Options are:
 \itemize{
   \item \code{"spectral"} Spectral embedding using the normalized Laplacian
   of the fuzzy 1-skeleton, with Gaussian noise added.
   \item \code{"normlaplacian"}. Spectral embedding using the normalized
   Laplacian of the fuzzy 1-skeleton, without noise.
   \item \code{"random"}. Coordinates assigned using a uniform random
   distribution between -10 and 10.
   \item \code{"lvrandom"}. Coordinates assigned using a Gaussian
   distribution with standard deviation 1e-4, as used in LargeVis
   (Tang et al., 2016) and t-SNE.
   \item \code{"laplacian"}. Spectral embedding using the Laplacian Eigenmap.
   \item \code{"pca"}. The first two principal components from PCA of
   \code{X} if \code{X} is a data frame, and from a 2-dimensional classical
   MDS if \code{X} is of class \code{"dist"}.
   \item \code{"spca"}. Like \code{"pca"}, but each dimension is then scaled
   so the standard deviation is 1e-4, to give a distribution similar to that
   used in t-SNE. This is an alias for \code{init = "pca", init_sdev =
   1e-4}.
   \item \code{"agspectral"} An "approximate global" modification of
   \code{"spectral"} which all edges in the graph to a value of 1, and then
   sets a random number of edges (\code{negative_sample_rate} edges per
   vertex) to 0.1, to approximate the effect of non-local affinities.
   \item A matrix of initial coordinates.
 }
For spectral initializations, (\code{"spectral"}, \code{"normlaplacian"},
\code{"laplacian"}, \code{"agspectral"}), if more than one connected
component is identified, no spectral initialization is attempted. Instead
a PCA-based initialization is attempted. If \code{verbose = TRUE} the
number of connected components are logged to the console. The existence of
multiple connected components implies that a global view of the data cannot
be attained with this initialization. Increasing the value of
\code{n_neighbors} may help.}

\item{init_sdev}{If non-\code{NULL}, scales each dimension of the initialized
coordinates (including any user-supplied matrix) to this standard
deviation. By default no scaling is carried out, except when \code{init =
"spca"}, in which case the value is \code{0.0001}. Scaling the input may
help if the unscaled versions result in initial coordinates with large
inter-point distances or outliers. This usually results in small gradients
during optimization and very little progress being made to the layout.
Shrinking the initial embedding by rescaling can help under these
circumstances. Scaling the result of \code{init = "pca"} is usually
recommended and \code{init = "spca"} as an alias for \code{init = "pca",
init_sdev = 1e-4} but for the spectral initializations the scaled versions
usually aren't necessary unless you are using a large value of
\code{n_neighbors} (e.g. \code{n_neighbors = 150} or higher). For
compatibility with recent versions of the Python UMAP package, if you are
using \code{init = "spectral"}, then you should also set
\code{init_sdev = "range"}, which will range scale each of the columns
containing the initial data between 0-10. This is not set by default to
maintain backwards compatibility with previous versions of uwot.}

\item{spread}{The effective scale of embedded points. In combination with
\code{min_dist}, this determines how clustered/clumped the embedded points
are.}

\item{min_dist}{The effective minimum distance between embedded points.
Smaller values will result in a more clustered/clumped embedding where
nearby points on the manifold are drawn closer together, while larger
values will result on a more even dispersal of points. The value should be
set relative to the \code{spread} value, which determines the scale at
which embedded points will be spread out.}

\item{repulsion_strength}{Weighting applied to negative samples in low
dimensional embedding optimization. Values higher than one will result in
greater weight being given to negative samples.}

\item{negative_sample_rate}{The number of negative edge/1-simplex samples to
use per positive edge/1-simplex sample in optimizing the low dimensional
embedding.}

\item{a}{More specific parameters controlling the embedding. If \code{NULL}
these values are set automatically as determined by \code{min_dist} and
\code{spread}.}

\item{b}{More specific parameters controlling the embedding. If \code{NULL}
these values are set automatically as determined by \code{min_dist} and
\code{spread}.}

\item{method}{Cost function to optimize. One of:
\itemize{
  \item{\code{"umap"}}. The UMAP method of McInnes and co-workers (2018).
  \item{\code{"tumap"}}. UMAP with the \code{a} and \code{b} parameters fixed
  to 1.
  \item{\code{"largevis"}}. The LargeVis method Tang and co-workers (2016).
}}

\item{approx_pow}{If \code{TRUE}, use an approximation to the power function
in the UMAP gradient, from
\url{https://martin.ankerl.com/2012/01/25/optimized-approximative-pow-in-c-and-cpp/}.}

\item{pcg_rand}{If \code{TRUE}, use the PCG random number generator (O'Neill,
2014) during optimization. Otherwise, use the faster (but probably less
statistically good) Tausworthe "taus88" generator. The default is
\code{TRUE}. This parameter has been superseded by \code{rng_type} -- if
both are set, \code{rng_type} takes precedence.}

\item{fast_sgd}{If \code{TRUE}, then the following combination of parameters
is set: \code{pcg_rand = TRUE}, \code{n_sgd_threads = "auto"} and
\code{approx_pow = TRUE}. The default is \code{FALSE}. Setting this to
\code{TRUE} will speed up the stochastic optimization phase, but give a
potentially less accurate embedding, and which will not be exactly
reproducible even with a fixed seed. For visualization, \code{fast_sgd =
TRUE} will give perfectly good results. For more generic dimensionality
reduction, it's safer to leave \code{fast_sgd = FALSE}. If \code{fast_sgd =
TRUE}, then user-supplied values of \code{pcg_rand}, \code{n_sgd_threads},
and \code{approx_pow} are ignored.}

\item{n_sgd_threads}{Number of threads to use during stochastic gradient
descent. If set to > 1, then be aware that if \code{batch = FALSE}, results
will \emph{not} be reproducible, even if \code{set.seed} is called with a
fixed seed before running. If set to \code{"auto"} then half the number of
concurrent threads supported by the system will be used.}

\item{grain_size}{The minimum amount of work to do on each thread. If this
value is set high enough, then less than \code{n_threads} or
\code{n_sgd_threads} will be used for processing, which might give a
performance improvement if the overhead of thread management and context
switching was outweighing the improvement due to concurrent processing.
This should be left at default (\code{1}) and work will be spread evenly
over all the threads specified.}

\item{verbose}{If \code{TRUE}, log details to the console.}

\item{batch}{If \code{TRUE}, then embedding coordinates are updated at the
end of each epoch rather than during the epoch. In batch mode, results are
reproducible with a fixed random seed even with \code{n_sgd_threads > 1},
at the cost of a slightly higher memory use. You may also have to modify
\code{learning_rate} and increase \code{n_epochs}, so whether this provides
a speed increase over the single-threaded optimization is likely to be
dataset and hardware-dependent.}

\item{opt_args}{A list of optimizer parameters, used when
\code{batch = TRUE}. The default optimization method used is Adam (Kingma
and Ba, 2014).
\itemize{
  \item \code{method} The optimization method to use. Either \code{"adam"}
  or \code{"sgd"} (stochastic gradient descent). Default: \code{"adam"}.
  \item \code{beta1} (Adam only). The weighting parameter for the
  exponential moving average of the first moment estimator. Effectively the
  momentum parameter. Should be a floating point value between 0 and 1.
  Higher values can smooth oscillatory updates in poorly-conditioned
  situations and may allow for a larger \code{learning_rate} to be
  specified, but too high can cause divergence. Default: \code{0.5}.
  \item \code{beta2} (Adam only). The weighting parameter for the
  exponential moving average of the uncentered second moment estimator.
  Should be a floating point value between 0 and 1. Controls the degree of
  adaptivity in the step-size. Higher values put more weight on previous
  time steps. Default: \code{0.9}.
  \item \code{eps} (Adam only). Intended to be a small value to prevent
  division by zero, but in practice can also affect convergence due to its
  interaction with \code{beta2}. Higher values reduce the effect of the
  step-size adaptivity and bring the behavior closer to stochastic gradient
  descent with momentum. Typical values are between 1e-8 and 1e-3. Default:
  \code{1e-7}.
  \item \code{alpha} The initial learning rate. Default: the value of the
  \code{learning_rate} parameter.
}}

\item{epoch_callback}{A function which will be invoked at the end of every
epoch. Its signature should be: \code{(epoch, n_epochs, coords)}, where:
\itemize{
  \item \code{epoch} The current epoch number (between \code{1} and
  \code{n_epochs}).
  \item \code{n_epochs} Number of epochs to use during the optimization of
  the embedded coordinates.
  \item \code{coords} The embedded coordinates as of the end of the current
  epoch, as a matrix with dimensions (N, \code{n_components}).
}}

\item{pca_method}{Method to carry out any PCA dimensionality reduction when
the \code{pca} parameter is specified. Allowed values are:
\itemize{
  \item{\code{"irlba"}}. Uses \code{\link[irlba]{prcomp_irlba}} from the
  \href{https://cran.r-project.org/package=irlba}{irlba} package.
  \item{\code{"rsvd"}}. Uses 5 iterations of \code{\link[irlba]{svdr}} from
  the \href{https://cran.r-project.org/package=irlba}{irlba} package.
  This is likely to give much faster but potentially less accurate results
  than using \code{"irlba"}. For the purposes of nearest neighbor
  calculation and coordinates initialization, any loss of accuracy doesn't
  seem to matter much.
  \item{\code{"bigstatsr"}}. Uses \code{\link[bigstatsr]{big_randomSVD}}
  from the \href{https://cran.r-project.org/package=bigstatsr}{bigstatsr}
  package. The SVD methods used in \code{bigstatsr} may be faster on
  systems without access to efficient linear algebra libraries (e.g.
  Windows). \strong{Note}: \code{bigstatsr} is \emph{not} a dependency of
  uwot: if you choose to use this package for PCA, you \emph{must} install
  it yourself.
  \item{\code{"svd"}}. Uses \code{\link[base]{svd}} for the SVD. This is
  likely to be slow for all but the smallest datasets.
  \item{\code{"auto"}} (the default). Uses \code{"irlba"}, unless more than
  50% of the full set of singular vectors would be calculated, in which
  case \code{"svd"} is used.
}}

\item{binary_edge_weights}{If \code{TRUE} then edge weights in the input
graph are treated as binary (0/1) rather than real valued.}

\item{rng_type}{The type of random number generator to use during
optimization. One of:
\itemize{
 \item{\code{"pcg"}}. Use the PCG random number generator (O'Neill, 2014).
 \item{\code{"tausworthe"}}. Use the Tausworthe "taus88" generator.
 \item{\code{"deterministic"}}. Use a deterministic number generator. This
 isn't actually random, but may provide enough variation in the negative
 sampling to give a good embedding and can provide a noticeable speed-up.
}
For backwards compatibility, by default this is unset and the choice of
\code{pcg_rand} is used (making "pcg" the effective default).}
}
\value{
A matrix of optimized coordinates.
}
\description{
Carry out dimensionality reduction on an input graph, where the distances in
the low dimensional space attempt to reproduce the neighbor relations in the
input data. By default, the cost function used to optimize the output
coordinates use the Uniform Manifold Approximation and Projection (UMAP)
method (McInnes et al., 2018), but the approach from LargeVis (Tang et al.,
2016) can also be used. This function can be used to produce a low
dimensional representation of the graph produced by
\code{\link{similarity_graph}}.
}
\examples{

iris30 <- iris[c(1:10, 51:60, 101:110), ]

# return a 30 x 30 sparse matrix with similarity data based on 10 nearest
# neighbors per item
iris30_sim_graph <- similarity_graph(iris30, n_neighbors = 10)
# produce 2D coordinates replicating the neighbor relations in the similarity
# graph
set.seed(42)
iris30_opt <- optimize_graph_layout(iris30_sim_graph, X = iris30)

# the above two steps are the same as:
# set.seed(42); iris_umap <- umap(iris30, n_neighbors = 10)

}
\references{
Kingma, D. P., & Ba, J. (2014).
Adam: A method for stochastic optimization.
\emph{arXiv preprint} \emph{arXiv}:1412.6980.
\url{https://arxiv.org/abs/1412.6980}

McInnes, L., Healy, J., & Melville, J. (2018).
UMAP: Uniform Manifold Approximation and Projection for Dimension Reduction
\emph{arXiv preprint} \emph{arXiv}:1802.03426.
\url{https://arxiv.org/abs/1802.03426}

O'Neill, M. E. (2014).
\emph{PCG: A family of simple fast space-efficient statistically good
algorithms for random number generation}
(Report No. HMC-CS-2014-0905). Harvey Mudd College.

Tang, J., Liu, J., Zhang, M., & Mei, Q. (2016, April).
Visualizing large-scale and high-dimensional data.
In \emph{Proceedings of the 25th International Conference on World Wide Web}
(pp. 287-297).
International World Wide Web Conferences Steering Committee.
\url{https://arxiv.org/abs/1602.00370}
}
