% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.build_forceframe_df}
\alias{.build_forceframe_df}
\title{Build a ForceFrame test data frame}
\usage{
.build_forceframe_df(records)
}
\arguments{
\item{records}{A list of ForceFrame test records from the API (parsed JSON).}
}
\value{
A \code{data.frame} where each row corresponds to a ForceFrame test record.
Internal function (not designed to be used directly by end users)
}
\description{
Internal helper to convert a list of ForceFrame test records into a tidy \code{data.frame}.
For character columns, \code{NULL} values are replaced with an empty string (\code{""})
to ensure consistent downstream handling.
}
\details{
Special handling is applied for the identifier column: some ForceFrame API endpoints
return this as \code{profileId}, while others return it as \code{athleteId}. This function
will populate the \code{profileId} column by taking the first non-empty value from
\code{profileId} or \code{athleteId}, in that order.
}
\keyword{internal}
