% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_vangogh_cvd.R
\name{check_all_vangogh_cvd}
\alias{check_all_vangogh_cvd}
\title{Batch Check CVD Accessibility for All Palettes}
\usage{
check_all_vangogh_cvd(simulate = FALSE)
}
\arguments{
\item{simulate}{Logical. If TRUE, displays simulations for each palette. Default FALSE.}
}
\value{
A data frame with CVD scores for all palettes
}
\description{
Runs CVD accessibility checks across all Van Gogh palettes and returns
a summary data frame. Useful for generating documentation and identifying
the most accessible palettes.
}
\examples{
\dontrun{
# Get scores for all palettes
all_scores <- check_all_vangogh_cvd()

# Find the most accessible palettes
library(dplyr)
all_scores \%>\%
  group_by(palette) \%>\%
  summarise(avg_distance = mean(min_distance)) \%>\%
  arrange(desc(avg_distance))
}

}
