% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc_length3d.R
\name{arc_length3d}
\alias{arc_length3d}
\title{Numeric arc length of a 3D parametric curve}
\usage{
arc_length3d(
  X,
  Y,
  Z,
  a,
  b,
  h = 1e-06,
  method_int = c("romberg", "integrate"),
  n_samples = 400,
  plot = FALSE,
  plot_mode = "lines",
  plot_line = list(color = "blue", width = 3, dash = "solid"),
  plot_marker = NULL,
  plot_title = NULL,
  plot_scene = list(xaxis = list(title = "x(t)"), yaxis = list(title = "y(t)"), zaxis =
    list(title = "z(t)")),
  plot_bg = list(paper = "white", plot = "white")
)
}
\arguments{
\item{X, Y, Z}{Functions of one variable \code{t} defining the parametric
curve coordinates.}

\item{a, b}{Numeric parameter limits for \code{t}.}

\item{h}{Numeric step size for centered finite differences used to approximate
the derivatives \eqn{dX/dt}, \eqn{dY/dt}, and \eqn{dZ/dt}.}

\item{method_int}{Character string. Either \code{"romberg"} (requires
the \pkg{pracma} package) or \code{"integrate"} (base R).}

\item{n_samples}{Integer. Number of sample points used when plotting
the curve (if \code{plot = TRUE}).}

\item{plot}{Logical. If \code{TRUE}, the function also produces a 3D
visualization of the curve using \code{\link[=plot_curve3d]{plot_curve3d()}}.}

\item{plot_mode}{Character string passed to \code{\link[=plot_curve3d]{plot_curve3d()}} as the
\code{mode} argument.}

\item{plot_line}{List with line styling options passed to \code{\link[=plot_curve3d]{plot_curve3d()}}.}

\item{plot_marker}{Optional list with marker styling options passed
to \code{\link[=plot_curve3d]{plot_curve3d()}}, or \code{NULL}.}

\item{plot_title}{Optional title for the plot. If \code{NULL}, a title
including the estimated arc length is generated.}

\item{plot_scene}{List specifying 3D axes and options, passed to
\code{\link[=plot_curve3d]{plot_curve3d()}}.}

\item{plot_bg}{List with background colors, passed to \code{\link[=plot_curve3d]{plot_curve3d()}}.}
}
\value{
A single numeric value: the approximated arc length of the curve
on the interval \eqn{[a, b]}.
}
\description{
Computes a numerical approximation to the arc length of the parametric
curve \eqn{(X(t), Y(t), Z(t))} on the interval \eqn{[a, b]} by integrating
the speed \eqn{\sqrt{(dx/dt)^2 + (dy/dt)^2 + (dz/dt)^2}}.
}
\details{
Derivatives are approximated by centered finite differences and the
integral is computed either by Romberg integration (via \pkg{pracma})
or by \code{\link[stats]{integrate}} from base R. Optionally, the
curve can be visualized with \code{\link[=plot_curve3d]{plot_curve3d()}}.
}
\examples{
X <- function(t) t^2 * cos(t)
Y <- function(t) t^3 * sin(3 * t)
Z <- function(t) t
arc_length3d(X, Y, Z, 0, 2 * pi)

# \donttest{
# if (requireNamespace("plotly", quietly = TRUE)) {
#   arc_length3d(
#     X, Y, Z, 0, 2 * pi,
#     plot = TRUE,
#     plot_line = list(color = "red", width = 3),
#     n_samples = 300
#   )
# }
# }

}
\seealso{
\code{\link[=curve_sample3d]{curve_sample3d()}}, \code{\link[=plot_curve3d]{plot_curve3d()}}
}
