% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor.R
\name{vetiver_compute_metrics}
\alias{vetiver_compute_metrics}
\title{Aggregate model metrics over time for monitoring}
\usage{
vetiver_compute_metrics(
  data,
  date_var,
  period,
  truth,
  estimate,
  ...,
  metric_set = yardstick::metrics,
  every = 1L,
  origin = NULL,
  before = 0L,
  after = 0L,
  complete = FALSE
)
}
\arguments{
\item{data}{A \code{data.frame} containing the columns specified by \code{truth},
\code{estimate}, and \code{...}.}

\item{date_var}{The column in \code{data} containing dates or date-times for
monitoring, to be aggregated with \code{.period}}

\item{period}{\verb{[character(1)]}

A string defining the period to group by. Valid inputs can be roughly
broken into:
\itemize{
\item \code{"year"}, \code{"quarter"}, \code{"month"}, \code{"week"}, \code{"day"}
\item \code{"hour"}, \code{"minute"}, \code{"second"}, \code{"millisecond"}
\item \code{"yweek"}, \code{"mweek"}
\item \code{"yday"}, \code{"mday"}
}}

\item{truth}{The column identifier for the true results (that
is \code{numeric} or \code{factor}). This should be an unquoted column name
although this argument is passed by expression and support
\link[rlang:topic-inject]{quasiquotation} (you can unquote column
names).}

\item{estimate}{The column identifier for the predicted results
(that is also \code{numeric} or \code{factor}). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name.}

\item{...}{A set of unquoted column names or one or more
\code{dplyr} selector functions to choose which variables contain the
class probabilities. If \code{truth} is binary, only 1 column should be selected,
and it should correspond to the value of \code{event_level}. Otherwise, there
should be as many columns as factor levels of \code{truth} and the ordering of
the columns should be the same as the factor levels of \code{truth}.}

\item{metric_set}{A \code{\link[yardstick:metric_set]{yardstick::metric_set()}} function for computing metrics.
Defaults to \code{\link[yardstick:metrics]{yardstick::metrics()}}.}

\item{every}{\verb{[positive integer(1)]}

The number of periods to group together.

For example, if the period was set to \code{"year"} with an every value of \code{2},
then the years 1970 and 1971 would be placed in the same group.}

\item{origin}{\verb{[Date(1) / POSIXct(1) / POSIXlt(1) / NULL]}

The reference date time value. The default when left as \code{NULL} is the
epoch time of \verb{1970-01-01 00:00:00}, \emph{in the time zone of the index}.

This is generally used to define the anchor time to count from, which is
relevant when the every value is \verb{> 1}.}

\item{before, after}{\verb{[integer(1) / Inf]}

The number of values before or after the current element to
include in the sliding window. Set to \code{Inf} to select all elements
before or after the current element. Negative values are allowed, which
allows you to "look forward" from the current element if used as the
\code{.before} value, or "look backwards" if used as \code{.after}.}

\item{complete}{\verb{[logical(1)]}

Should the function be evaluated on complete windows only? If \code{FALSE},
the default, then partial computations will be allowed.}
}
\value{
A dataframe of metrics.
}
\description{
These three functions can be used for model monitoring (such as in a
monitoring dashboard):
\itemize{
\item \code{vetiver_compute_metrics()} computes metrics (such as accuracy for a
classification model or RMSE for a regression model) at a chosen time
aggregation \code{period}
\item \code{\link[=vetiver_pin_metrics]{vetiver_pin_metrics()}} updates an existing pin storing model metrics
over time
\item \code{\link[=vetiver_plot_metrics]{vetiver_plot_metrics()}} creates a plot of metrics over time
}
}
\details{
For arguments used more than once in your monitoring dashboard,
such as \code{date_var}, consider using
\href{https://bookdown.org/yihui/rmarkdown/parameterized-reports.html}{R Markdown parameters}
to reduce repetition and/or errors.
}
\examples{
\dontshow{if (rlang::is_installed(c("dplyr", "parsnip", "modeldata"))) withAutoprint(\{ # examplesIf}
library(dplyr)
library(parsnip)
data(Chicago, package = "modeldata")
Chicago <- Chicago |> select(ridership, date, all_of(stations))
training_data <- Chicago |> filter(date < "2009-01-01")
testing_data <- Chicago |> filter(date >= "2009-01-01", date < "2011-01-01")
monitoring <- Chicago |> filter(date >= "2011-01-01", date < "2012-12-31")
lm_fit <- linear_reg() |> fit(ridership ~ ., data = training_data)

library(pins)
b <- board_temp()

original_metrics <-
    augment(lm_fit, new_data = testing_data) |>
    vetiver_compute_metrics(date, "week", ridership, .pred, every = 4L)

new_metrics <-
    augment(lm_fit, new_data = monitoring) |>
    vetiver_compute_metrics(date, "week", ridership, .pred, every = 4L)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=vetiver_pin_metrics]{vetiver_pin_metrics()}}, \code{\link[=vetiver_plot_metrics]{vetiver_plot_metrics()}}
}
