% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_mortality_law.R
\name{smooth_mortality_law}
\alias{smooth_mortality_law}
\title{Function to smooth mortality rates using MortalityLaw package}
\usage{
smooth_mortality_law(.data, .var, law = "gompertz", ...)
}
\arguments{
\item{.data}{A vital object}

\item{.var}{name of variable to smooth. This should contain mortality rates.}

\item{law}{name of mortality law. For available mortality laws, users can check the \code{\link[MortalityLaws]{availableLaws}}. Argument ignored if a custom law supplied.
function to learn about the available options.}

\item{...}{Additional arguments are passed to \code{\link[MortalityLaws]{MortalityLaw}}.}
}
\value{
vital with added columns containing smoothed values and their standard errors
}
\description{
This smoothing function allows smoothing of a variable in a vital object using
the MortalityLaw package.
The vital object is returned along with some additional columns containing
information about the smoothed variable: \code{.smooth} containing the
smoothed values, and \code{.smooth_se} containing the corresponding standard errors.
}
\examples{
norway_mortality |> smooth_mortality_law(Mortality)
}
\author{
Sixian Tang and Rob J Hyndman
}
\keyword{smooth}
