% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ids_get_ed.R
\name{ids_get_ed}
\alias{ids_get_ed}
\title{Get full IDS tables from EconDataverse datasets}
\usage{
ids_get_ed(table = "debt_statistics", columns = NULL, quiet = FALSE)
}
\arguments{
\item{table}{Character string naming the table from the IDS dataset.
Default: \code{"debt_statistics"}.}

\item{columns}{Character vector naming the columns. Defaults to \code{NULL}.}

\item{quiet}{A logical parameter indicating whether messages should be
printed to the console.}
}
\value{
A \code{data.frame} containing the requested IDS table, or \code{NULL} if
the download fails.
}
\description{
A convenience wrapper around \code{econdatasets::ed_get()} that retrieves
tables from the World Bank International Debt Statistics (IDS) dataset
hosted on EconDataverse Hugging Face repositories.
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
\donttest{
# Get the default debt statistics table
debt_statitics <- ids_get_ed()

# Get a different table from IDS
series_data <- ids_get_ed("series")
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[econdatasets:ed_get]{econdatasets::ed_get()}} for the underlying function that
downloads data from EconDataverse repositories.
}
