% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmst_calculations.R
\name{cumulative_rmst_bands}
\alias{cumulative_rmst_bands}
\title{Cumulative RMST bands for survival curves}
\usage{
cumulative_rmst_bands(
  df,
  fit,
  tte.name,
  event.name,
  treat.name,
  weight.name = NULL,
  draws_sb = 1000,
  xlab = "months",
  ylim_pad = 0.5,
  rmst_max_legend = "left",
  rmst_max_cex = 0.7,
  plot = TRUE
)
}
\arguments{
\item{df}{Data frame containing survival data.}

\item{fit}{Survival fit object (output from KM_diff).}

\item{tte.name}{Name of time-to-event variable in \code{df}.}

\item{event.name}{Name of event indicator variable in \code{df}.}

\item{treat.name}{Name of treatment group variable in \code{df}.}

\item{weight.name}{Optional name of weights variable in \code{df}.}

\item{draws_sb}{Number of resampling draws for simultaneous bands (default: 1000).}

\item{xlab}{Label for x-axis (default: "months").}

\item{ylim_pad}{Padding for y-axis limits (default: 0.5).}

\item{rmst_max_legend}{Position for RMST legend (default: "left").}

\item{rmst_max_cex}{Text size for RMST legend (default: 0.7).}

\item{plot}{Logical; if TRUE, plot the results. Default is TRUE.}
}
\value{
A list with elements:
\item{at_points}{Time points used for RMST calculation}
\item{rmst_time}{Cumulative RMST estimates}
\item{sig2_rmst_time}{Variance of RMST estimates}
\item{rmst_time_lower}{Pointwise lower confidence interval}
\item{rmst_time_upper}{Pointwise upper confidence interval}
\item{rmst_maxtau_ci}{RMST and CI at maximum time}
\item{rmst_text}{Text summary for legend}
\item{c_alpha_band}{Critical value for simultaneous band}
\item{rmst_time_sb_lower}{Simultaneous band lower bound}
\item{rmst_time_sb_upper}{Simultaneous band upper bound}
}
\description{
Calculates cumulative Restricted Mean Survival Time (RMST) and confidence bands for survival curves using resampling.
Optionally plots the cumulative RMST curve, pointwise confidence intervals, and simultaneous confidence bands.
}
