% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_match_digits}
\alias{whapi_match_digits}
\title{Digit matching helper (with partial threshold)}
\usage{
whapi_match_digits(haystack, needle, min_partial = 6)
}
\arguments{
\item{haystack}{String with potential digits to search in.}

\item{needle}{String with digits to search for.}

\item{min_partial}{Minimum number of digits required to allow partial match.}
}
\value{
Logical (\code{TRUE}/\code{FALSE}) indicating whether a match was found.
}
\description{
Matches a digit-only \code{needle} inside a digit-only \code{haystack}.
If \code{needle} has at least \code{min_partial} digits, partial matching is allowed.
Otherwise, only exact matches are considered.
}
\examples{
whapi_match_digits("tel: 81998765432", "987654")
#> TRUE
whapi_match_digits("12345", "123", min_partial = 4)
#> FALSE
}
