% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dateManupulations.R
\name{water_year}
\alias{water_year}
\title{Derive water year value for a date}
\usage{
water_year(date, start_month = 10, start_hour = 9, tz = "UTC")
}
\arguments{
\item{date}{the (vector of) dates for which the water year will be calculated}

\item{start_month}{the month in which the water year starts, default is October}

\item{start_hour}{the time of the day in which the water year starts, default is 9}

\item{tz}{time zone for the record, defaults to "UTC"}
}
\value{
The water year value
}
\description{
Derive water year value for a date
}
\examples{
\dontrun{
water_year(c(as.POSIXct("1958-10-01 09:00:00", tz = "UTC"),
             as.POSIXct("2021-10-01 12:00:00", tz = "UTC"),
             as.POSIXct("1918-10-01 08:55:00", tz = "UTC")))

water_year(c(as.Date("2021-01-01"),as.Date("2021-11-01"),
as.Date("2019-02-01"),as.Date("1965-09-30")))
}
}
