% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_ghcn_monthly.R
\name{import_ghcn_monthly_temp}
\alias{import_ghcn_monthly_temp}
\alias{import_ghcn_monthly_prcp}
\title{Import data from the Global Historical Climatology monthly (GHCNm) database}
\usage{
import_ghcn_monthly_temp(
  table = c("inventory", "data"),
  dataset = c("qcu", "qcf", "qfe")
)

import_ghcn_monthly_prcp(
  station = NULL,
  year = NULL,
  table = c("inventory", "data"),
  progress = rlang::is_interactive()
)
}
\arguments{
\item{table}{Either \code{"inventory"}, \code{"data"}, or both. The tables to read and
return in the output list.}

\item{dataset}{For \code{\link[=import_ghcn_monthly_temp]{import_ghcn_monthly_temp()}}. One of the below options.
More information is available at
\url{https://www.ncei.noaa.gov/pub/data/ghcn/v4/readme.txt}.
\itemize{
\item \code{"qcu"}: Quality Control, Unadjusted
\item \code{"qcf"}: Quality Control, Adjusted, using the Pairwise Homogeneity
Algorithm.
\item \code{"qfe"}: Quality Control, Adjusted, Estimated using the Pairwise
Homogeneity Algorithm. Only the years 1961-2010 are provided. This is to
help maximize station coverage when calculating normals.
}}

\item{station}{For \code{\link[=import_ghcn_monthly_prcp]{import_ghcn_monthly_prcp()}}. The specific stations to
import monthly precipitation data for.}

\item{year}{One or more years of interest. If \code{NULL}, the default, all years
of data available for the chosen \code{station}s will be imported. Note that, in
the GHCNd and GHCNm, files are split by station but not year, so setting a
\code{year} will not speed up the download. Specifying fewer years will improve
the speed of a GHCNh download, however.}

\item{progress}{For \code{\link[=import_ghcn_monthly_prcp]{import_ghcn_monthly_prcp()}}. Show a progress bar when
importing many stations? Defaults to \code{TRUE} in interactive R sessions.
Passed to \code{.progress} in \code{\link[purrr:map]{purrr::map()}}.}
}
\value{
a list of \link[tibble:tibble-package]{tibbles}
}
\description{
This function is a convenient way to access the monthly summaries of the
GHCN. Monthly average temperature is available via
\code{\link[=import_ghcn_monthly_temp]{import_ghcn_monthly_temp()}} and monthly precipitation via
\code{\link[=import_ghcn_monthly_prcp]{import_ghcn_monthly_prcp()}}. Note that these functions can take a few
minutes to run, and parallelism is only enabled for precipitation data.
}
\section{Parallel Processing}{


If you are importing a lot of meteorological data, this can take a long
while. This is because each combination of year and station requires
downloading a separate data file from NOAA's online data directory, and the
time each download takes can quickly add up. Many data import functions in
\code{{worldmet}} can use parallel processing to speed downloading up, powered
by the capable \code{{mirai}} package. If users have any \code{{mirai}} "daemons"
set, these functions will download files in parallel. The greatest benefits
will be seen if you spawn as many daemons as you have cores on your
machine, although one fewer than the available cores is often a good rule
of thumb. Your mileage may vary, however, and naturally spawning more
daemons than station-year combinations will lead to diminishing returns.

\if{html}{\out{<div class="sourceCode">}}\preformatted{# set workers - once per session
mirai::daemons(4)

# import lots of data - NB: no change in the import function!
big_met <- import_ghcn_hourly(code = "UKI0000EGLL", year = 2010:2025)
}\if{html}{\out{</div>}}
}

\seealso{
Other GHCN functions: 
\code{\link{import_ghcn_countries}()},
\code{\link{import_ghcn_daily}()},
\code{\link{import_ghcn_hourly}()},
\code{\link{import_ghcn_inventory}()},
\code{\link{import_ghcn_stations}()}
}
\author{
Jack Davison
}
\concept{GHCN functions}
