% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_met.R
\name{write_met}
\alias{write_met}
\title{Export a meteorological data frame in files, chunked by site and year}
\usage{
write_met(
  x,
  path = ".",
  ext = c("rds", "delim", "parquet"),
  delim = ",",
  suffix = "",
  progress = rlang::is_interactive()
)
}
\arguments{
\item{x}{A data frame imported by \code{\link[=import_isd_hourly]{import_isd_hourly()}},
\code{\link[=import_ghcn_hourly]{import_ghcn_hourly()}}, or \code{\link[=import_ghcn_daily]{import_ghcn_daily()}}.}

\item{path}{The path to a directory to save each file. By default, this is
the working directory.}

\item{ext}{The file type to use when saving the data. Can be \code{"rds"},
\code{"delim"} or \code{"parquet"}. Note that \code{"parquet"} requires the \code{arrow}
package.}

\item{delim}{Delimiter used to separate values when \code{ext = "delim"}. Must be
a single character. Defaults to being comma-delimited (\code{","}).}

\item{suffix}{An additional suffix to append to file names. Useful examples
could be \code{"_ISD"}, \code{"_hourly"}, \code{"_lite"}, and so on.}

\item{progress}{Show a progress bar when writing many stations/years?
Defaults to \code{TRUE} in interactive R sessions. Passed to \code{.progress} in
\code{\link[purrr:map]{purrr::walk()}}.}
}
\value{
\code{write_met()} returns \code{path} invisibly.
}
\description{
Writes a text file in the ADMS format to a location of the user's choosing,
with optional interpolation of missing values. At present this function only
works with data from \code{\link[=import_isd_hourly]{import_isd_hourly()}}; it will later be expanded to work
with \code{\link[=import_ghcn_hourly]{import_ghcn_hourly()}} also.
}
\examples{
\dontrun{
# import some data then export it
dat <- import_isd_hourly(year = 2012)
write_met(dat)
}
}
\seealso{
Other Met writing functions: 
\code{\link{write_adms}()}
}
\concept{Met writing functions}
