# Extracted from test-CFI.R:219

# setup ------------------------------------------------------------------------
library(testthat)
test_env <- simulate_test_env(package = "xplainfi", path = "..")
attach(test_env, warn.conflicts = FALSE)

# test -------------------------------------------------------------------------
skip_if_not_installed("ranger")
skip_if_not_installed("mlr3learners")
skip_if_not_installed("knockoff")
set.seed(123)
task = tgen("friedman1")$generate(n = 150)
learner = lrn("regr.ranger", num.trees = 50)
measure = msr("regr.mse")
test_custom_sampler(
		CFI,
		task = task,
		learner = learner,
		measure = measure,
		sampler = KnockoffSampler$new(task),
		expected_sampler_class = "KnockoffSampler"
	)
