# Extracted from test-CFI.R:247

# setup ------------------------------------------------------------------------
library(testthat)
test_env <- simulate_test_env(package = "xplainfi", path = "..")
attach(test_env, warn.conflicts = FALSE)

# test -------------------------------------------------------------------------
skip_if_not_installed("ranger")
skip_if_not_installed("mlr3learners")
skip_if_not_installed("seqknockoff")
set.seed(123)
task = tgen("friedman1")$generate(n = 150)
test_custom_sampler(
		CFI,
		task = task,
		learner = lrn("regr.ranger", num.trees = 50),
		measure = msr("regr.mse"),
		sampler = KnockoffSequentialSampler$new(task),
		expected_sampler_class = "KnockoffSequentialSampler"
	)
