% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xp_xtras.R
\name{backfill_iofv}
\alias{backfill_iofv}
\title{Add individual objective function to data}
\usage{
backfill_iofv(xpdb, .problem = NULL, .subprob = NULL, .label = "iOFV")
}
\arguments{
\item{xpdb}{<\code{xpose_data}> or <\code{xp_xtras}> object}

\item{.problem}{Problem number}

\item{.subprob}{Subproblem number}

\item{.label}{The name of the new column. \code{iOFV} is the default.}
}
\value{
<\code{xp_xtras}> object with new column in the data and a
column with \code{iofv} var type.
}
\description{
Add individual objective function to data
}
\details{
This function will only work for objects with software listed as
\code{nonmem} or \code{nlmixr2}. For \code{nonmem}, the object should haves a \code{phi}
file and with an \code{OBJ} column in that file. For \code{nlmixr2}, the fit
object data should have individual observation likelihoods in a column
called \code{NLMIXRLLIKOBS} (this is a current standard, but is checked at runtime).
}
\examples{

xpdb_x \%>\%
  backfill_iofv() \%>\%
  list_vars()

}
